/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.internal;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Optional;
import java.util.stream.Stream;

public enum GenericReflection {


    public static Type getReturnType(Method m, Class forClass) {
        Type genericReturnType = m.getGenericReturnType();
        if (genericReturnType instanceof Class) {
            return genericReturnType;
        }
        Class<?> declaringClass = m.getDeclaringClass();
        Optional<Type> extendsType = Stream.of(Stream.of(forClass.getGenericSuperclass()), Stream.of(forClass.getGenericInterfaces())).flatMap(s -> s).filter(t -> declaringClass.equals(GenericReflection.erase(t))).findFirst();
        TypeVariable<Class<?>>[] typeParameters = declaringClass.getTypeParameters();
        if (extendsType.isPresent() && extendsType.get() instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)extendsType.get();
            Type[] actualTypeArguments = type.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (!typeParameters[i].equals(genericReturnType)) continue;
                return actualTypeArguments[i];
            }
        }
        return m.getReturnType();
    }

    private static Class<?> erase(Type t) {
        return t instanceof ParameterizedType ? GenericReflection.erase(((ParameterizedType)t).getRawType()) : (Class<?>)t;
    }
}

