/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.wire.channel;

import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.threads.NamedThreadFactory;
import net.openhft.chronicle.threads.PauserMode;
import net.openhft.chronicle.wire.Comment;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.channel.ChannelHandler;
import net.openhft.chronicle.wire.channel.ChannelHeader;
import net.openhft.chronicle.wire.channel.ChronicleChannelCfg;
import net.openhft.chronicle.wire.channel.ChronicleContext;
import net.openhft.chronicle.wire.channel.ErrorReplyHandler;
import net.openhft.chronicle.wire.channel.SystemContext;
import net.openhft.chronicle.wire.channel.impl.SocketRegistry;
import net.openhft.chronicle.wire.channel.impl.TCPChronicleChannel;
import org.jetbrains.annotations.Nullable;

public class ChronicleGatewayMain
extends ChronicleContext
implements Closeable,
Runnable {
    public static final int PORT = Integer.getInteger("port", 1248);
    private static final PauserMode PAUSER_MODE = PauserMode.valueOf(System.getProperty("pauserMode", PauserMode.balanced.name()));
    private static final boolean USE_AFFINITY = Jvm.getBoolean("useAffinity");
    transient ServerSocketChannel ssc;
    transient Thread thread;
    @Comment(value="PauserMode to use in buffered channels")
    PauserMode pauserMode = PauserMode.balanced;
    @Comment(value="Default buffering configuration if not set by the Handler")
    private boolean buffered = false;
    private ExecutorService service;

    public ChronicleGatewayMain(String url) throws InvalidMarshallableException {
        this(url, new SocketRegistry(), SystemContext.INSTANCE);
        this.addCloseable(this.socketRegistry());
    }

    public ChronicleGatewayMain(String url, SocketRegistry socketRegistry, SystemContext systemContext) throws InvalidMarshallableException {
        super(url, socketRegistry);
        this.systemContext(systemContext);
    }

    public static void main(String ... args) throws IOException, InvalidMarshallableException {
        ChronicleGatewayMain.main(ChronicleGatewayMain.class, ChronicleGatewayMain::new, args.length == 0 ? "" : args[0]).run();
    }

    protected static <T extends ChronicleGatewayMain> ChronicleGatewayMain main(Class<T> mainClass, Function<String, T> supplier, String config) throws IOException {
        ChronicleGatewayMain main;
        if (config.isEmpty()) {
            ChronicleGatewayMain chronicleGatewayMain = ((ChronicleGatewayMain)supplier.apply("tcp://localhost:" + PORT)).pauserMode(PAUSER_MODE).buffered(Jvm.getBoolean("buffered"));
            chronicleGatewayMain.useAffinity(USE_AFFINITY);
            chronicleGatewayMain.pauserMode = PAUSER_MODE;
            main = chronicleGatewayMain;
        } else {
            main = (ChronicleGatewayMain)Marshallable.fromFile(mainClass, config);
        }
        return main;
    }

    public ChronicleGatewayMain pauserMode(PauserMode pauserMode) {
        this.pauserMode = pauserMode;
        return this;
    }

    @Override
    public boolean buffered() {
        return this.buffered;
    }

    @Override
    public ChronicleGatewayMain buffered(boolean buffered) {
        this.buffered = buffered;
        return this;
    }

    public synchronized ChronicleGatewayMain start() throws IOException {
        if (this.isClosed()) {
            throw new IllegalStateException("Closed");
        }
        this.bindSSC();
        if (this.thread == null) {
            this.thread = new Thread(this::run, "acceptor");
            this.thread.setDaemon(true);
            this.thread.start();
        }
        return this;
    }

    private void bindSSC() throws IOException {
        if (this.ssc == null) {
            this.ssc = this.socketRegistry().acquireServerSocketChannel(this.url());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.service = Executors.newCachedThreadPool(new NamedThreadFactory("connections"));
        Throwable thrown = null;
        try {
            this.bindSSC();
            Object channelCfg = ((ChronicleChannelCfg)((ChronicleChannelCfg)new ChronicleChannelCfg().port(this.url().getPort())).pauserMode(this.pauserMode)).buffered(this.buffered);
            while (!this.isClosed()) {
                SocketChannel sc = this.ssc.accept();
                sc.socket().setTcpNoDelay(true);
                TCPChronicleChannel channel = new TCPChronicleChannel(this.systemContext(), (ChronicleChannelCfg)channelCfg, sc, this::replaceInHeader, this::replaceOutHeader);
                this.service.submit(() -> this.handle(channel));
            }
        }
        catch (Throwable e) {
            try {
                thrown = e;
            }
            catch (Throwable throwable) {
                Thread.yield();
                boolean closing = this.isClosing() || this.socketRegistry().isClosing();
                this.close();
                if (thrown != null && !closing) {
                    Jvm.error().on(this.getClass(), thrown);
                }
                throw throwable;
            }
            Thread.yield();
            boolean closing = this.isClosing() || this.socketRegistry().isClosing();
            this.close();
            if (thrown != null && !closing) {
                Jvm.error().on(this.getClass(), thrown);
            }
        }
        Thread.yield();
        boolean closing = this.isClosing() || this.socketRegistry().isClosing();
        this.close();
        if (thrown != null && !closing) {
            Jvm.error().on(this.getClass(), thrown);
        }
    }

    protected ChannelHeader replaceInHeader(ChannelHeader channelHeader) {
        return channelHeader;
    }

    protected ChannelHeader replaceOutHeader(ChannelHeader channelHeader) {
        if (channelHeader instanceof ChannelHandler) {
            ChannelHandler handler = (ChannelHandler)channelHeader;
            return handler.responseHeader(this);
        }
        return channelHeader;
    }

    private void waitForService() {
        try {
            this.service.shutdownNow();
            this.service.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Jvm.warn().on(this.getClass(), e);
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected void performClose() {
        super.performClose();
        Closeable.closeQuietly((Object)this.ssc);
        if (this.service != null) {
            this.waitForService();
        }
    }

    /*
     * Exception decompiling
     */
    void handle(TCPChronicleChannel channel) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    protected ChannelHandler validateHandler(Marshallable marshallable) {
        if (!(marshallable instanceof ChannelHandler)) {
            return new ErrorReplyHandler().errorMsg("The header must be a ChannelHandler");
        }
        return (ChannelHandler)marshallable;
    }

    @Override
    public int port() {
        return this.ssc.socket().getLocalPort();
    }
}

