/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes.internal;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytesStore;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.bytes.RandomDataInput;
import net.openhft.chronicle.bytes.internal.CommonMappedBytes;
import net.openhft.chronicle.bytes.internal.ReferenceCountedUtil;
import net.openhft.chronicle.bytes.util.DecoratedBufferOverflowException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.annotation.NonNegative;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.Longs;
import net.openhft.chronicle.core.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleMappedBytes
extends CommonMappedBytes {
    public SingleMappedBytes(@NotNull MappedFile mappedFile) throws IllegalStateException {
        this(mappedFile, "");
    }

    protected SingleMappedBytes(@NotNull MappedFile mappedFile, String name) throws IllegalStateException {
        super(mappedFile, name);
        try {
            this.bytesStore(mappedFile.acquireByteStore(this, 0L));
            assert (this.bytesStore.reservedBy(this));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    @NotNull
    public SingleMappedBytes write(@NonNegative long offsetInRDO, byte[] byteArray, @NonNegative int offset, @NonNegative int length) throws IllegalStateException, BufferOverflowException {
        Longs.requireNonNegative(offsetInRDO);
        ObjectUtils.requireNonNull(byteArray);
        Longs.requireNonNegative(offset);
        Longs.requireNonNegative(length);
        this.throwExceptionIfClosed();
        long wp = offsetInRDO;
        if (length + offset > byteArray.length) {
            throw new ArrayIndexOutOfBoundsException("bytes.length=" + byteArray.length + ", length=" + length + ", offset=" + offset);
        }
        if (offsetInRDO + (long)length > this.writeLimit) {
            throw new DecoratedBufferOverflowException(String.format("write failed. offset: %d + length: %d > writeLimit: %d", offsetInRDO, length, this.writeLimit));
        }
        int remaining = length;
        while (remaining > 0) {
            long safeCopySize = this.copySize(wp);
            if (safeCopySize + this.mappedFile.overlapSize() >= (long)remaining) {
                this.bytesStore.write(wp, byteArray, offset, remaining);
                return this;
            }
            this.bytesStore.write(wp, byteArray, offset, (int)safeCopySize);
            offset = (int)((long)offset + safeCopySize);
            wp += safeCopySize;
            remaining = (int)((long)remaining - safeCopySize);
        }
        return this;
    }

    @Override
    @NotNull
    public SingleMappedBytes write(@NonNegative long writeOffset, @NotNull RandomDataInput bytes, @NonNegative long readOffset, @NonNegative long length) throws BufferOverflowException, BufferUnderflowException, IllegalStateException {
        long safeCopySize;
        Longs.requireNonNegative(writeOffset);
        ReferenceCountedUtil.throwExceptionIfReleased(bytes);
        Longs.requireNonNegative(readOffset);
        Longs.requireNonNegative(length);
        this.throwExceptionIfReleased();
        long wp = writeOffset;
        if (writeOffset + length > this.writeLimit) {
            throw new DecoratedBufferOverflowException(String.format("write failed. End of write: %d + %d > writeLimit: %d", writeOffset, length, this.writeLimit));
        }
        for (long remaining = length; remaining > 0L; remaining -= safeCopySize) {
            safeCopySize = this.copySize(wp);
            if (safeCopySize + this.mappedFile.overlapSize() >= remaining) {
                this.bytesStore.write(wp, bytes, readOffset, remaining);
                return this;
            }
            this.bytesStore.write(wp, bytes, readOffset, safeCopySize);
            readOffset += safeCopySize;
            wp += safeCopySize;
        }
        return this;
    }

    private long copySize(@NonNegative long writePosition) {
        long size = this.mappedFile.chunkSize();
        return size - writePosition % size;
    }

    @Override
    @NotNull
    public Bytes<Void> readPositionRemaining(@NonNegative long position, @NonNegative long remaining) throws BufferUnderflowException, IllegalStateException {
        long limit = position + remaining;
        if (this.writeLimit < limit) {
            this.writeLimit(limit);
        }
        if (Jvm.isAssertEnabled()) {
            this.readLimit(limit);
        } else {
            this.uncheckedWritePosition(limit);
        }
        return this.readPosition(position);
    }

    @Override
    @NotNull
    public Bytes<Void> writeSkip(long bytesToSkip) throws BufferOverflowException, IllegalStateException {
        this.writeCheckOffset(this.writePosition(), Math.min(128L, bytesToSkip));
        this.uncheckedWritePosition(this.writePosition() + bytesToSkip);
        return this;
    }

    @NotNull
    private BufferOverflowException newBufferOverflowException(@NonNegative long offset) {
        BufferOverflowException exception = new BufferOverflowException();
        exception.initCause(new IllegalArgumentException("Offset out of bound " + offset));
        return exception;
    }

    @Override
    @NotNull
    public Bytes<Void> clear() throws IllegalStateException {
        long start;
        this.readPosition = start = 0L;
        this.uncheckedWritePosition(start);
        this.writeLimit = this.mappedFile.capacity();
        return this;
    }

    @Override
    public int peekVolatileInt() throws IllegalStateException {
        @Nullable MappedBytesStore bytesStore = (MappedBytesStore)this.bytesStore;
        long address = bytesStore.address + bytesStore.translate(this.readPosition);
        @Nullable Memory memory = bytesStore.memory;
        if ((address & 0x3FL) <= 60L) {
            ObjectUtils.requireNonNull(memory);
            UnsafeMemory.unsafeLoadFence();
            return UnsafeMemory.unsafeGetInt(address);
        }
        return memory.readVolatileInt(address);
    }

    @Override
    public boolean compareAndSwapLong(@NonNegative long offset, long expected, long value) throws BufferOverflowException, IllegalStateException {
        this.throwExceptionIfClosed();
        if (offset < 0L || offset > this.capacity()) {
            throw this.newBufferOverflowException(offset);
        }
        return this.bytesStore.compareAndSwapLong(offset, expected, value);
    }

    @Override
    public Bytes<Void> write(@NotNull BytesStore<?, ?> bytes) throws BufferOverflowException, IllegalStateException {
        assert (bytes != this) : "you should not write to yourself !";
        long length = bytes.readRemaining();
        this.bytesStore.write(this.writePosition(), bytes);
        this.writeSkip(length);
        return this;
    }
}

