/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.bytes.HexDumpBytes;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.annotation.DontChain;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.InvalidMarshallableException;
import net.openhft.chronicle.core.io.ValidatableUtil;

@DontChain
public interface BytesMarshallable
extends ReadBytesMarshallable,
WriteBytesMarshallable {
    @Override
    default public boolean usesSelfDescribingMessage() {
        return false;
    }

    @Override
    default public void readMarshallable(BytesIn<?> bytes) throws IORuntimeException, BufferUnderflowException, IllegalStateException, InvalidMarshallableException {
        BytesUtil.readMarshallable(this, bytes);
        ValidatableUtil.validate(this);
    }

    @Override
    default public void writeMarshallable(BytesOut<?> bytes) throws IllegalStateException, BufferOverflowException, BufferUnderflowException, ArithmeticException, InvalidMarshallableException {
        ValidatableUtil.validate(this);
        BytesUtil.writeMarshallable(this, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String $toString() {
        ValidatableUtil.startValidateDisabled();
        try {
            HexDumpBytes bytes = new HexDumpBytes();
            this.writeMarshallable(bytes);
            String s = "# " + this.getClass().getName() + "\n" + bytes.toHexString();
            bytes.releaseLast();
            String string = s;
            return string;
        }
        catch (Throwable e) {
            String string = e.toString();
            return string;
        }
        finally {
            ValidatableUtil.endValidateDisabled();
        }
    }
}

