/*
 * Decompiled with CFR 0.152.
 */
package stormpot.internal;

import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import stormpot.Expiration;
import stormpot.Poolable;
import stormpot.SlotInfo;

public final class TimeSpreadExpiration<T extends Poolable>
implements Expiration<T> {
    private final long fromMillis;
    private final long toMillis;
    private final TimeUnit unit;

    public TimeSpreadExpiration(long lowerBound, long upperBound, TimeUnit unit) {
        Objects.requireNonNull(unit, "TimeUnit cannot be null.");
        if (lowerBound < 1L) {
            throw new IllegalArgumentException("The lower bound cannot be less than 1.");
        }
        if (upperBound < lowerBound) {
            throw new IllegalArgumentException("The upper bound must be greater than or equal to the lower bound.");
        }
        this.fromMillis = unit.toMillis(lowerBound);
        this.toMillis = unit.toMillis(upperBound);
        this.unit = unit;
    }

    @Override
    public boolean hasExpired(SlotInfo<? extends T> info) {
        long age;
        long expirationAge = info.getStamp();
        if (expirationAge == 0L) {
            expirationAge = this.computeExpirationDeadline();
            info.setStamp(expirationAge);
        }
        return (age = info.getAgeMillis()) >= expirationAge;
    }

    long computeExpirationDeadline() {
        long maxDelta = this.toMillis - this.fromMillis;
        ThreadLocalRandom prng = ThreadLocalRandom.current();
        long fudgeFactor = this.fromMillis == this.toMillis ? 0L : Math.abs((long)prng.nextInt() % maxDelta);
        return this.fromMillis + fudgeFactor;
    }

    public String toString() {
        long lower = this.unit.convert(this.fromMillis, TimeUnit.MILLISECONDS);
        long upper = this.unit.convert(this.toMillis, TimeUnit.MILLISECONDS);
        return "TimeSpreadExpiration(" + lower + " to " + upper + " " + String.valueOf((Object)this.unit) + ")";
    }
}

