/*
 * Decompiled with CFR 0.152.
 */
package stormpot.internal;

import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import stormpot.Allocator;
import stormpot.Completion;
import stormpot.PoolBuilder;
import stormpot.Poolable;
import stormpot.internal.AllocationController;
import stormpot.internal.BSlot;
import stormpot.internal.BSlotPadded;
import stormpot.internal.NanoClock;
import stormpot.internal.RefillPile;
import stormpot.internal.StackCompletion;

public final class DirectAllocationController<T extends Poolable>
extends AllocationController<T> {
    private final LinkedTransferQueue<BSlot<T>> live;
    private final BSlot<T> poisonPill;
    private final long size;
    private final AtomicLong shutdownState;
    private final AtomicLong poisonedSlots;
    private final StackCompletion shutdownCompletion;

    DirectAllocationController(LinkedTransferQueue<BSlot<T>> live, RefillPile<T> disregardPile, PoolBuilder<T> builder, BSlot<T> poisonPill) {
        this.live = live;
        this.poisonPill = poisonPill;
        this.size = builder.getSize();
        this.poisonedSlots = new AtomicLong();
        Allocator<T> allocator = builder.getAllocator();
        boolean optimizeForMemory = builder.isOptimizeForReducedMemoryUsage();
        for (long i = 0L; i < this.size; ++i) {
            BSlot<T> slot = optimizeForMemory ? new BSlot<T>(live, this.poisonedSlots) : new BSlotPadded<T>(live, this.poisonedSlots);
            try {
                slot.obj = allocator.allocate(slot);
                slot.createdNanos = System.nanoTime();
                slot.dead2live();
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected exception.", e);
            }
            live.offer(slot);
        }
        this.shutdownState = new AtomicLong(this.size);
        this.shutdownCompletion = new StackCompletion(timeout -> {
            BSlot slot;
            if (Thread.interrupted()) {
                throw new InterruptedException("Interrupted while waiting for pool shut down to complete.");
            }
            TimeUnit unit = timeout == null ? null : timeout.getBaseUnit();
            long timeoutNanos = timeout == null ? 0L : timeout.getTimeoutInBaseUnit();
            long startNanos = NanoClock.nanoTime();
            long timeoutLeft = timeoutNanos;
            disregardPile.refill();
            while (this.shutdownState.get() > 0L && (slot = unit == null ? (BSlot)live.take() : (BSlot)live.poll(timeoutLeft, unit)) != null) {
                if (slot != poisonPill) {
                    this.shutdownState.getAndDecrement();
                }
                disregardPile.refill();
                timeoutLeft = NanoClock.timeoutLeft(startNanos, timeoutNanos);
            }
            live.offer(poisonPill);
            return this.shutdownState.get() == 0L;
        });
    }

    @Override
    Completion shutdown() {
        if (this.shutdownState.get() > 0L) {
            this.poisonPill.dead2live();
            this.live.offer(this.poisonPill);
        }
        return this.shutdownCompletion;
    }

    @Override
    Completion switchAllocator(Allocator<T> replacementAllocator) {
        throw new UnsupportedOperationException("Direct pools do not support switching allocators");
    }

    @Override
    void offerDeadSlot(BSlot<T> slot) {
        if (slot.poison != null) {
            slot.poison = null;
            this.poisonedSlots.getAndDecrement();
        }
        slot.dead2live();
        this.live.offer(slot);
    }

    @Override
    void setTargetSize(long size) {
        throw new UnsupportedOperationException("Target size cannot be changed. This pool was created with a fixed set of objects using the Pool.of(...) method. Attempted to set target size to " + size + ".");
    }

    @Override
    long getTargetSize() {
        return this.size;
    }

    @Override
    long getAllocationCount() {
        return this.size;
    }

    @Override
    long getFailedAllocationCount() {
        return 0L;
    }

    @Override
    long countLeakedObjects() {
        return -1L;
    }

    @Override
    public long allocatedSize() {
        return this.size;
    }

    @Override
    long inUse() {
        long inUse = 0L;
        long liveSize = 0L;
        for (BSlot<T> slot : this.live) {
            ++liveSize;
            if (!slot.isClaimedOrThreadLocal()) continue;
            ++inUse;
        }
        return this.size - liveSize + inUse;
    }
}

