/*
 * Decompiled with CFR 0.152.
 */
package stormpot.internal;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.Reference;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import stormpot.Allocator;
import stormpot.PoolException;
import stormpot.Poolable;
import stormpot.Slot;
import stormpot.SlotInfo;
import stormpot.internal.BlazePool;
import stormpot.internal.NanoClock;

public class BSlot<T extends Poolable>
implements Slot,
SlotInfo<T> {
    private static final int CLAIMED = 1;
    private static final int TLR_CLAIMED = 2;
    private static final int LIVING = 3;
    private static final int DEAD = 4;
    private static final VarHandle STATE;
    private volatile int state = 4;
    final BlockingQueue<BSlot<T>> live;
    final AtomicLong poisonedSlots;
    long stamp;
    long createdNanos;
    public T obj;
    public Exception poison;
    public Reference<Object> leakCheck;
    Allocator<T> allocator;

    public BSlot(BlockingQueue<BSlot<T>> live, AtomicLong poisonedSlots) {
        this.live = live;
        this.poisonedSlots = poisonedSlots;
    }

    final boolean compareAndSet(int expected, int update) {
        return STATE.compareAndSet(this, expected, update);
    }

    final void lazySet(int update) {
        STATE.setOpaque(this, update);
    }

    int get() {
        return this.state;
    }

    @Override
    public void expire(Poolable obj) {
        if (this.poison != BlazePool.EXPLICIT_EXPIRE_POISON) {
            this.poison = BlazePool.EXPLICIT_EXPIRE_POISON;
        }
    }

    @Override
    public void release(Poolable obj) {
        if (this.poison == BlazePool.EXPLICIT_EXPIRE_POISON) {
            this.poisonedSlots.getAndIncrement();
        }
        int slotState = this.getClaimState();
        this.lazySet(3);
        if (slotState == 1) {
            this.live.offer(this);
        }
    }

    private int getClaimState() {
        int slotState = this.get();
        if (slotState > 2) {
            throw this.badStateOnTransitionToLive(slotState);
        }
        return slotState;
    }

    private PoolException badStateOnTransitionToLive(int slotState) {
        Object state = switch (slotState) {
            case 4 -> "DEAD";
            case 3 -> "LIVING";
            default -> "STATE[" + slotState + "]";
        };
        return new PoolException("Slot release from bad state: " + (String)state + ". You most likely called release() twice on the same object.");
    }

    void claim2live() {
        this.lazySet(3);
    }

    public void claimTlr2live() {
        this.lazySet(3);
    }

    public void dead2live() {
        this.lazySet(3);
    }

    public void claim2dead() {
        this.lazySet(4);
    }

    public boolean live2claim() {
        return this.compareAndSet(3, 1);
    }

    public boolean live2claimTlr() {
        return this.compareAndSet(3, 2);
    }

    boolean live2dead() {
        return this.compareAndSet(3, 4);
    }

    @Override
    public long getAgeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(NanoClock.elapsed(this.createdNanos));
    }

    @Override
    public long getCreatedNanoTime() {
        return this.createdNanos;
    }

    @Override
    public T getPoolable() {
        return this.obj;
    }

    boolean isDead() {
        return this.get() == 4;
    }

    boolean isLive() {
        return this.get() == 3;
    }

    boolean isClaimed() {
        return this.get() == 1;
    }

    boolean isClaimedOrThreadLocal() {
        int state = this.get();
        return state == 1 || state == 2;
    }

    @Override
    public long getStamp() {
        return this.stamp;
    }

    @Override
    public void setStamp(long stamp) {
        this.stamp = stamp;
    }

    public String toString() {
        int state = this.get();
        Object s = state == 1 ? "CLAIMED" : (state == 2 ? "TLR_CLAIMED" : (state == 3 ? "LIVING" : (state == 4 ? "DEAD" : "UnknownState(" + state + ")")));
        return "BSolt[" + (String)s + ", obj = " + String.valueOf(this.obj) + ", poison = " + String.valueOf(this.poison) + "]";
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            STATE = lookup.findVarHandle(BSlot.class, "state", Integer.TYPE).withInvokeExactBehavior();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new AssertionError("Failed to initialise the state VarHandle.", e);
        }
    }
}

