/*
 * Decompiled with CFR 0.152.
 */
package stormpot;

import stormpot.Allocator;
import stormpot.Completion;
import stormpot.ManagedPool;
import stormpot.PoolBuilder;
import stormpot.PoolTap;
import stormpot.Poolable;
import stormpot.Pooled;
import stormpot.Slot;
import stormpot.internal.AllocationProcess;
import stormpot.internal.PoolBuilderImpl;

public interface Pool<T extends Poolable>
extends PoolTap<T> {
    public static <T extends Poolable> PoolBuilder<T> from(Allocator<T> allocator) {
        return Pool.fromThreaded(allocator);
    }

    public static <T extends Poolable> PoolBuilder<T> fromThreaded(Allocator<T> allocator) {
        return new PoolBuilderImpl<T>(AllocationProcess.threaded(), allocator);
    }

    public static <T extends Poolable> PoolBuilder<T> fromInline(Allocator<T> allocator) {
        return new PoolBuilderImpl<T>(AllocationProcess.inline(), allocator);
    }

    @SafeVarargs
    public static <T> Pool<Pooled<T>> of(final T ... objects) {
        Allocator allocator = new Allocator<Pooled<T>>(){
            private int index;

            @Override
            public Pooled<T> allocate(Slot slot) {
                return new Pooled<Object>(slot, objects[this.index++]);
            }

            @Override
            public void deallocate(Pooled<T> poolable) {
            }
        };
        PoolBuilderImpl builder = new PoolBuilderImpl(AllocationProcess.direct(), allocator);
        builder.setSize(objects.length);
        return builder.build();
    }

    public Completion shutdown();

    public Completion switchAllocator(Allocator<T> var1);

    public void setTargetSize(long var1);

    public long getTargetSize();

    public ManagedPool getManagedPool();

    public PoolTap<T> getThreadSafeTap();

    public PoolTap<T> getVirtualThreadSafeTap();

    public PoolTap<T> getSingleThreadedTap();
}

