/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.videoconferencing.saas;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.bluemind.webmodule.server.NeedVertx;
import net.bluemind.webmodule.server.WebModule;
import net.bluemind.webmodule.server.handlers.AbstractIndexHandler;
import net.bluemind.webmodule.server.handlers.IWebModuleConsumer;
import net.bluemind.webmodule.server.handlers.StaticFileHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisioHandler
extends AbstractIndexHandler
implements NeedVertx,
IWebModuleConsumer {
    private static final Logger logger = LoggerFactory.getLogger(VisioHandler.class);
    private static final Pattern roomPattern = Pattern.compile("(?:[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-5][0-9a-fA-F]{3}-[89ABab][0-9a-fA-F]{3}-[0-9a-fA-F]{12}$)|(?:[0-9a-zA-Z-_]{7,14}$)");
    private static final String BLUEMIND_VIDEO_DOMAIN = VisioHandler.tryReadDomain(Paths.get("/etc/bm", "bluemind.video"), "video.bluemind.net");
    private Vertx vertx;
    private WebModule webModule;
    private StaticFileHandler staticHandler;

    private static String tryReadDomain(Path path, String string) {
        if (path.toFile().exists()) {
            try {
                return new String(Files.readAllBytes(path)).trim();
            }
            catch (IOException iOException) {
                logger.warn(iOException.getMessage());
            }
        }
        return string;
    }

    public VisioHandler() {
        logger.info("VISIO HANDLER STARTED");
    }

    protected String getTemplateName() {
        return "visio.ftl";
    }

    public void handle(HttpServerRequest httpServerRequest) {
        Matcher matcher = roomPattern.matcher(httpServerRequest.path());
        if (!matcher.find()) {
            logger.debug("{} does not match room pattern, serving static content", (Object)httpServerRequest.path());
            this.staticHandler.handle(httpServerRequest);
            return;
        }
        super.handle(httpServerRequest);
    }

    protected void loadPageModel(HttpServerRequest httpServerRequest, Map<String, Object> map) {
        String string = httpServerRequest.headers().get("BMSessionId");
        if (string == null || string.isEmpty()) {
            map.put("BMLang", this.getAnonymousLang(httpServerRequest));
        }
        map.put("BMJitsiSaasDomain", BLUEMIND_VIDEO_DOMAIN);
    }

    private String getAnonymousLang(HttpServerRequest httpServerRequest) {
        String string = httpServerRequest.headers().get("Accept-Language");
        if (string == null) {
            return "en";
        }
        return Locale.LanguageRange.parse(string).stream().map(languageRange -> Locale.forLanguageTag(languageRange.getRange())).findFirst().orElse(new Locale.Builder().setLanguage("en").build()).getLanguage().toLowerCase();
    }

    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
        this.setupStaticHandler();
    }

    public void setModule(WebModule webModule) {
        super.setModule(webModule);
        this.webModule = webModule;
        this.setupStaticHandler();
    }

    private void setupStaticHandler() {
        if (this.webModule != null && this.vertx != null) {
            this.staticHandler = new StaticFileHandler(this.vertx, this.webModule.root, this.webModule.index, this.webModule.resources, true, true);
        }
    }
}

