/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SearchableSnapshots
extends Base {
    private final int indicesCount;
    @Nullable
    private final Integer fullCopyIndicesCount;
    @Nullable
    private final Integer sharedCacheIndicesCount;
    public static final JsonpDeserializer<SearchableSnapshots> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchableSnapshots::setupSearchableSnapshotsDeserializer);

    private SearchableSnapshots(Builder builder) {
        super(builder);
        this.indicesCount = ApiTypeHelper.requireNonNull(builder.indicesCount, this, "indicesCount");
        this.fullCopyIndicesCount = builder.fullCopyIndicesCount;
        this.sharedCacheIndicesCount = builder.sharedCacheIndicesCount;
    }

    public static SearchableSnapshots of(Function<Builder, ObjectBuilder<SearchableSnapshots>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int indicesCount() {
        return this.indicesCount;
    }

    @Nullable
    public final Integer fullCopyIndicesCount() {
        return this.fullCopyIndicesCount;
    }

    @Nullable
    public final Integer sharedCacheIndicesCount() {
        return this.sharedCacheIndicesCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("indices_count");
        generator.write(this.indicesCount);
        if (this.fullCopyIndicesCount != null) {
            generator.writeKey("full_copy_indices_count");
            generator.write(this.fullCopyIndicesCount);
        }
        if (this.sharedCacheIndicesCount != null) {
            generator.writeKey("shared_cache_indices_count");
            generator.write(this.sharedCacheIndicesCount);
        }
    }

    protected static void setupSearchableSnapshotsDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::indicesCount, JsonpDeserializer.integerDeserializer(), "indices_count");
        op.add(Builder::fullCopyIndicesCount, JsonpDeserializer.integerDeserializer(), "full_copy_indices_count");
        op.add(Builder::sharedCacheIndicesCount, JsonpDeserializer.integerDeserializer(), "shared_cache_indices_count");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<SearchableSnapshots> {
        private Integer indicesCount;
        @Nullable
        private Integer fullCopyIndicesCount;
        @Nullable
        private Integer sharedCacheIndicesCount;

        public final Builder indicesCount(int value) {
            this.indicesCount = value;
            return this;
        }

        public final Builder fullCopyIndicesCount(@Nullable Integer value) {
            this.fullCopyIndicesCount = value;
            return this;
        }

        public final Builder sharedCacheIndicesCount(@Nullable Integer value) {
            this.sharedCacheIndicesCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchableSnapshots build() {
            this._checkSingleUse();
            return new SearchableSnapshots(this);
        }
    }
}

