/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.snapshot.CreateRepositoryResponse;
import co.elastic.clients.elasticsearch.snapshot.Repository;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CreateRepositoryRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Time masterTimeout;
    private final String name;
    @Nullable
    private final Time timeout;
    @Nullable
    private final Boolean verify;
    private final Repository repository;
    public static final JsonpDeserializer<CreateRepositoryRequest> _DESERIALIZER = CreateRepositoryRequest.createCreateRepositoryRequestDeserializer();
    public static final Endpoint<CreateRepositoryRequest, CreateRepositoryResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateRepositoryRequest, CreateRepositoryResponse>("es/snapshot.create_repository", request -> "PUT", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.verify != null) {
            params.put("verify", String.valueOf(request.verify));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, CreateRepositoryResponse._DESERIALIZER);

    private CreateRepositoryRequest(Builder builder) {
        this.masterTimeout = builder.masterTimeout;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.timeout = builder.timeout;
        this.verify = builder.verify;
        this.repository = ApiTypeHelper.requireNonNull(builder.repository, this, "repository");
    }

    public static CreateRepositoryRequest of(Function<Builder, ObjectBuilder<CreateRepositoryRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final Boolean verify() {
        return this.verify;
    }

    public final Repository repository() {
        return this.repository;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.repository.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<CreateRepositoryRequest> createCreateRepositoryRequestDeserializer() {
        JsonpDeserializer<Repository> valueDeserializer = Repository._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().repository((Repository)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)((Object)event))).build());
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CreateRepositoryRequest> {
        @Nullable
        private Time masterTimeout;
        private String name;
        @Nullable
        private Time timeout;
        @Nullable
        private Boolean verify;
        private Repository repository;

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder verify(@Nullable Boolean value) {
            this.verify = value;
            return this;
        }

        public final Builder repository(Repository value) {
            this.repository = value;
            return this;
        }

        public final Builder repository(Function<Repository.Builder, ObjectBuilder<Repository>> fn) {
            return this.repository(fn.apply(new Repository.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            Repository value = Repository._DESERIALIZER.deserialize(parser, mapper);
            return this.repository(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CreateRepositoryRequest build() {
            this._checkSingleUse();
            return new CreateRepositoryRequest(this);
        }
    }
}

