/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.InvalidateApiKeyResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InvalidateApiKeyRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String id;
    private final List<String> ids;
    @Nullable
    private final String name;
    @Nullable
    private final Boolean owner;
    @Nullable
    private final String realmName;
    @Nullable
    private final String username;
    public static final JsonpDeserializer<InvalidateApiKeyRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InvalidateApiKeyRequest::setupInvalidateApiKeyRequestDeserializer);
    public static final Endpoint<InvalidateApiKeyRequest, InvalidateApiKeyResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<InvalidateApiKeyRequest, InvalidateApiKeyResponse>("es/security.invalidate_api_key", request -> "DELETE", request -> "/_security/api_key", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, InvalidateApiKeyResponse._DESERIALIZER);

    private InvalidateApiKeyRequest(Builder builder) {
        this.id = builder.id;
        this.ids = ApiTypeHelper.unmodifiable(builder.ids);
        this.name = builder.name;
        this.owner = builder.owner;
        this.realmName = builder.realmName;
        this.username = builder.username;
    }

    public static InvalidateApiKeyRequest of(Function<Builder, ObjectBuilder<InvalidateApiKeyRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    public final List<String> ids() {
        return this.ids;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final Boolean owner() {
        return this.owner;
    }

    @Nullable
    public final String realmName() {
        return this.realmName;
    }

    @Nullable
    public final String username() {
        return this.username;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (ApiTypeHelper.isDefined(this.ids)) {
            generator.writeKey("ids");
            generator.writeStartArray();
            for (String item0 : this.ids) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.owner != null) {
            generator.writeKey("owner");
            generator.write(this.owner);
        }
        if (this.realmName != null) {
            generator.writeKey("realm_name");
            generator.write(this.realmName);
        }
        if (this.username != null) {
            generator.writeKey("username");
            generator.write(this.username);
        }
    }

    protected static void setupInvalidateApiKeyRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ids");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::owner, JsonpDeserializer.booleanDeserializer(), "owner");
        op.add(Builder::realmName, JsonpDeserializer.stringDeserializer(), "realm_name");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<InvalidateApiKeyRequest> {
        @Nullable
        private String id;
        @Nullable
        private List<String> ids;
        @Nullable
        private String name;
        @Nullable
        private Boolean owner;
        @Nullable
        private String realmName;
        @Nullable
        private String username;

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder ids(List<String> list) {
            this.ids = Builder._listAddAll(this.ids, list);
            return this;
        }

        public final Builder ids(String value, String ... values) {
            this.ids = Builder._listAdd(this.ids, value, values);
            return this;
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public final Builder owner(@Nullable Boolean value) {
            this.owner = value;
            return this;
        }

        public final Builder realmName(@Nullable String value) {
            this.realmName = value;
            return this;
        }

        public final Builder username(@Nullable String value) {
            this.username = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InvalidateApiKeyRequest build() {
            this._checkSingleUse();
            return new InvalidateApiKeyRequest(this);
        }
    }
}

