/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeBufferPool
implements JsonpSerializable {
    @Nullable
    private final Long count;
    @Nullable
    private final String totalCapacity;
    @Nullable
    private final Long totalCapacityInBytes;
    @Nullable
    private final String used;
    @Nullable
    private final Long usedInBytes;
    public static final JsonpDeserializer<NodeBufferPool> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeBufferPool::setupNodeBufferPoolDeserializer);

    private NodeBufferPool(Builder builder) {
        this.count = builder.count;
        this.totalCapacity = builder.totalCapacity;
        this.totalCapacityInBytes = builder.totalCapacityInBytes;
        this.used = builder.used;
        this.usedInBytes = builder.usedInBytes;
    }

    public static NodeBufferPool of(Function<Builder, ObjectBuilder<NodeBufferPool>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long count() {
        return this.count;
    }

    @Nullable
    public final String totalCapacity() {
        return this.totalCapacity;
    }

    @Nullable
    public final Long totalCapacityInBytes() {
        return this.totalCapacityInBytes;
    }

    @Nullable
    public final String used() {
        return this.used;
    }

    @Nullable
    public final Long usedInBytes() {
        return this.usedInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.count != null) {
            generator.writeKey("count");
            generator.write(this.count);
        }
        if (this.totalCapacity != null) {
            generator.writeKey("total_capacity");
            generator.write(this.totalCapacity);
        }
        if (this.totalCapacityInBytes != null) {
            generator.writeKey("total_capacity_in_bytes");
            generator.write(this.totalCapacityInBytes);
        }
        if (this.used != null) {
            generator.writeKey("used");
            generator.write(this.used);
        }
        if (this.usedInBytes != null) {
            generator.writeKey("used_in_bytes");
            generator.write(this.usedInBytes);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupNodeBufferPoolDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::totalCapacity, JsonpDeserializer.stringDeserializer(), "total_capacity");
        op.add(Builder::totalCapacityInBytes, JsonpDeserializer.longDeserializer(), "total_capacity_in_bytes");
        op.add(Builder::used, JsonpDeserializer.stringDeserializer(), "used");
        op.add(Builder::usedInBytes, JsonpDeserializer.longDeserializer(), "used_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeBufferPool> {
        @Nullable
        private Long count;
        @Nullable
        private String totalCapacity;
        @Nullable
        private Long totalCapacityInBytes;
        @Nullable
        private String used;
        @Nullable
        private Long usedInBytes;

        public final Builder count(@Nullable Long value) {
            this.count = value;
            return this;
        }

        public final Builder totalCapacity(@Nullable String value) {
            this.totalCapacity = value;
            return this;
        }

        public final Builder totalCapacityInBytes(@Nullable Long value) {
            this.totalCapacityInBytes = value;
            return this;
        }

        public final Builder used(@Nullable String value) {
            this.used = value;
            return this;
        }

        public final Builder usedInBytes(@Nullable Long value) {
            this.usedInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeBufferPool build() {
            this._checkSingleUse();
            return new NodeBufferPool(this);
        }
    }
}

