/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FileSystemTotal
implements JsonpSerializable {
    @Nullable
    private final String available;
    @Nullable
    private final Long availableInBytes;
    @Nullable
    private final String free;
    @Nullable
    private final Long freeInBytes;
    @Nullable
    private final String total;
    @Nullable
    private final Long totalInBytes;
    public static final JsonpDeserializer<FileSystemTotal> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FileSystemTotal::setupFileSystemTotalDeserializer);

    private FileSystemTotal(Builder builder) {
        this.available = builder.available;
        this.availableInBytes = builder.availableInBytes;
        this.free = builder.free;
        this.freeInBytes = builder.freeInBytes;
        this.total = builder.total;
        this.totalInBytes = builder.totalInBytes;
    }

    public static FileSystemTotal of(Function<Builder, ObjectBuilder<FileSystemTotal>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String available() {
        return this.available;
    }

    @Nullable
    public final Long availableInBytes() {
        return this.availableInBytes;
    }

    @Nullable
    public final String free() {
        return this.free;
    }

    @Nullable
    public final Long freeInBytes() {
        return this.freeInBytes;
    }

    @Nullable
    public final String total() {
        return this.total;
    }

    @Nullable
    public final Long totalInBytes() {
        return this.totalInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.available != null) {
            generator.writeKey("available");
            generator.write(this.available);
        }
        if (this.availableInBytes != null) {
            generator.writeKey("available_in_bytes");
            generator.write(this.availableInBytes);
        }
        if (this.free != null) {
            generator.writeKey("free");
            generator.write(this.free);
        }
        if (this.freeInBytes != null) {
            generator.writeKey("free_in_bytes");
            generator.write(this.freeInBytes);
        }
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total);
        }
        if (this.totalInBytes != null) {
            generator.writeKey("total_in_bytes");
            generator.write(this.totalInBytes);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFileSystemTotalDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::available, JsonpDeserializer.stringDeserializer(), "available");
        op.add(Builder::availableInBytes, JsonpDeserializer.longDeserializer(), "available_in_bytes");
        op.add(Builder::free, JsonpDeserializer.stringDeserializer(), "free");
        op.add(Builder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes");
        op.add(Builder::total, JsonpDeserializer.stringDeserializer(), "total");
        op.add(Builder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FileSystemTotal> {
        @Nullable
        private String available;
        @Nullable
        private Long availableInBytes;
        @Nullable
        private String free;
        @Nullable
        private Long freeInBytes;
        @Nullable
        private String total;
        @Nullable
        private Long totalInBytes;

        public final Builder available(@Nullable String value) {
            this.available = value;
            return this;
        }

        public final Builder availableInBytes(@Nullable Long value) {
            this.availableInBytes = value;
            return this;
        }

        public final Builder free(@Nullable String value) {
            this.free = value;
            return this;
        }

        public final Builder freeInBytes(@Nullable Long value) {
            this.freeInBytes = value;
            return this;
        }

        public final Builder total(@Nullable String value) {
            this.total = value;
            return this;
        }

        public final Builder totalInBytes(@Nullable Long value) {
            this.totalInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FileSystemTotal build() {
            this._checkSingleUse();
            return new FileSystemTotal(this);
        }
    }
}

