/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.CloseJobResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CloseJobRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowNoJobs;
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Boolean force;
    private final String jobId;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<CloseJobRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CloseJobRequest::setupCloseJobRequestDeserializer);
    public static final Endpoint<CloseJobRequest, CloseJobResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CloseJobRequest, CloseJobResponse>("es/ml.close_job", request -> "POST", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_close");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoJobs != null) {
            params.put("allow_no_jobs", String.valueOf(request.allowNoJobs));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, CloseJobResponse._DESERIALIZER);

    private CloseJobRequest(Builder builder) {
        this.allowNoJobs = builder.allowNoJobs;
        this.allowNoMatch = builder.allowNoMatch;
        this.force = builder.force;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.timeout = builder.timeout;
    }

    public static CloseJobRequest of(Function<Builder, ObjectBuilder<CloseJobRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Deprecated
    @Nullable
    public final Boolean allowNoJobs() {
        return this.allowNoJobs;
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Boolean force() {
        return this.force;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowNoMatch != null) {
            generator.writeKey("allow_no_match");
            generator.write(this.allowNoMatch);
        }
        if (this.force != null) {
            generator.writeKey("force");
            generator.write(this.force);
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            this.timeout.serialize(generator, mapper);
        }
    }

    protected static void setupCloseJobRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowNoMatch, JsonpDeserializer.booleanDeserializer(), "allow_no_match");
        op.add(Builder::force, JsonpDeserializer.booleanDeserializer(), "force");
        op.add(Builder::timeout, Time._DESERIALIZER, "timeout");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CloseJobRequest> {
        @Nullable
        private Boolean allowNoJobs;
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Boolean force;
        private String jobId;
        @Nullable
        private Time timeout;

        @Deprecated
        public final Builder allowNoJobs(@Nullable Boolean value) {
            this.allowNoJobs = value;
            return this;
        }

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder force(@Nullable Boolean value) {
            this.force = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CloseJobRequest build() {
            this._checkSingleUse();
            return new CloseJobRequest(this);
        }
    }
}

