/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GrokProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    private final Map<String, String> patternDefinitions;
    private final List<String> patterns;
    @Nullable
    private final Boolean traceMatch;
    public static final JsonpDeserializer<GrokProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GrokProcessor::setupGrokProcessorDeserializer);

    private GrokProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.patternDefinitions = ApiTypeHelper.unmodifiable(builder.patternDefinitions);
        this.patterns = ApiTypeHelper.unmodifiableRequired(builder.patterns, (Object)this, "patterns");
        this.traceMatch = builder.traceMatch;
    }

    public static GrokProcessor of(Function<Builder, ObjectBuilder<GrokProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Grok;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public final Map<String, String> patternDefinitions() {
        return this.patternDefinitions;
    }

    public final List<String> patterns() {
        return this.patterns;
    }

    @Nullable
    public final Boolean traceMatch() {
        return this.traceMatch;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing);
        }
        if (ApiTypeHelper.isDefined(this.patternDefinitions)) {
            generator.writeKey("pattern_definitions");
            generator.writeStartObject();
            for (Map.Entry entry : this.patternDefinitions.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.patterns)) {
            generator.writeKey("patterns");
            generator.writeStartArray();
            for (String string : this.patterns) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.traceMatch != null) {
            generator.writeKey("trace_match");
            generator.write(this.traceMatch);
        }
    }

    protected static void setupGrokProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::patternDefinitions, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "pattern_definitions");
        op.add(Builder::patterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "patterns");
        op.add(Builder::traceMatch, JsonpDeserializer.booleanDeserializer(), "trace_match");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GrokProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private Map<String, String> patternDefinitions;
        private List<String> patterns;
        @Nullable
        private Boolean traceMatch;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder patternDefinitions(Map<String, String> map) {
            this.patternDefinitions = Builder._mapPutAll(this.patternDefinitions, map);
            return this;
        }

        public final Builder patternDefinitions(String key, String value) {
            this.patternDefinitions = Builder._mapPut(this.patternDefinitions, key, value);
            return this;
        }

        public final Builder patterns(List<String> list) {
            this.patterns = Builder._listAddAll(this.patterns, list);
            return this;
        }

        public final Builder patterns(String value, String ... values) {
            this.patterns = Builder._listAdd(this.patterns, value, values);
            return this;
        }

        public final Builder traceMatch(@Nullable Boolean value) {
            this.traceMatch = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GrokProcessor build() {
            this._checkSingleUse();
            return new GrokProcessor(this);
        }
    }
}

