/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregationSource;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CompositeAggregation
extends BucketAggregationBase
implements AggregationVariant {
    private final Map<String, FieldValue> after;
    @Nullable
    private final Integer size;
    private final List<Map<String, CompositeAggregationSource>> sources;
    public static final JsonpDeserializer<CompositeAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompositeAggregation::setupCompositeAggregationDeserializer);

    private CompositeAggregation(Builder builder) {
        super(builder);
        this.after = ApiTypeHelper.unmodifiable(builder.after);
        this.size = builder.size;
        this.sources = ApiTypeHelper.unmodifiable(builder.sources);
    }

    public static CompositeAggregation of(Function<Builder, ObjectBuilder<CompositeAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Composite;
    }

    public final Map<String, FieldValue> after() {
        return this.after;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public final List<Map<String, CompositeAggregationSource>> sources() {
        return this.sources;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.after)) {
            generator.writeKey("after");
            generator.writeStartObject();
            for (Map.Entry<String, FieldValue> entry : this.after.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        if (ApiTypeHelper.isDefined(this.sources)) {
            generator.writeKey("sources");
            generator.writeStartArray();
            for (Map map : this.sources) {
                generator.writeStartObject();
                if (map != null) {
                    for (Map.Entry item1 : map.entrySet()) {
                        generator.writeKey((String)item1.getKey());
                        ((CompositeAggregationSource)item1.getValue()).serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    protected static void setupCompositeAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BucketAggregationBase.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::after, JsonpDeserializer.stringMapDeserializer(FieldValue._DESERIALIZER), "after");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::sources, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(CompositeAggregationSource._DESERIALIZER)), "sources");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CompositeAggregation> {
        @Nullable
        private Map<String, FieldValue> after;
        @Nullable
        private Integer size;
        @Nullable
        private List<Map<String, CompositeAggregationSource>> sources;

        public final Builder after(Map<String, FieldValue> map) {
            this.after = Builder._mapPutAll(this.after, map);
            return this;
        }

        public final Builder after(String key, FieldValue value) {
            this.after = Builder._mapPut(this.after, key, value);
            return this;
        }

        public final Builder after(String key, Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.after(key, fn.apply(new FieldValue.Builder()).build());
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder sources(List<Map<String, CompositeAggregationSource>> list) {
            this.sources = Builder._listAddAll(this.sources, list);
            return this;
        }

        public final Builder sources(Map<String, CompositeAggregationSource> value, Map<String, CompositeAggregationSource> ... values) {
            this.sources = Builder._listAdd(this.sources, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompositeAggregation build() {
            this._checkSingleUse();
            return new CompositeAggregation(this);
        }
    }
}

