/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core.registry;

import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventProcessor;
import io.github.resilience4j.core.Registry;
import io.github.resilience4j.core.RegistryStore;
import io.github.resilience4j.core.registry.EntryAddedEvent;
import io.github.resilience4j.core.registry.EntryRemovedEvent;
import io.github.resilience4j.core.registry.EntryReplacedEvent;
import io.github.resilience4j.core.registry.InMemoryRegistryStore;
import io.github.resilience4j.core.registry.RegistryEvent;
import io.github.resilience4j.core.registry.RegistryEventConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class AbstractRegistry<E, C>
implements Registry<E, C> {
    protected static final String DEFAULT_CONFIG = "default";
    protected static final String CONFIG_MUST_NOT_BE_NULL = "Config must not be null";
    protected static final String CONSUMER_MUST_NOT_BE_NULL = "EventConsumers must not be null";
    protected static final String SUPPLIER_MUST_NOT_BE_NULL = "Supplier must not be null";
    protected static final String TAGS_MUST_NOT_BE_NULL = "Tags must not be null";
    private static final String NAME_MUST_NOT_BE_NULL = "Name must not be null";
    private static final String REGISTRY_STORE_MUST_NOT_BE_NULL = "Registry Store must not be null";
    protected final RegistryStore<E> entryMap;
    protected final ConcurrentMap<String, C> configurations = new ConcurrentHashMap<String, C>();
    protected final Map<String, String> registryTags;
    private final RegistryEventProcessor eventProcessor;

    public AbstractRegistry(C defaultConfig) {
        this(defaultConfig, Collections.emptyMap());
    }

    public AbstractRegistry(C defaultConfig, Map<String, String> registryTags) {
        this(defaultConfig, new ArrayList<RegistryEventConsumer<E>>(), registryTags);
    }

    public AbstractRegistry(C defaultConfig, RegistryEventConsumer<E> registryEventConsumer) {
        this(defaultConfig, registryEventConsumer, Collections.emptyMap());
    }

    public AbstractRegistry(C defaultConfig, RegistryEventConsumer<E> registryEventConsumer, Map<String, String> tags) {
        this(defaultConfig, Collections.singletonList(Objects.requireNonNull(registryEventConsumer, CONSUMER_MUST_NOT_BE_NULL)), tags);
    }

    public AbstractRegistry(C defaultConfig, List<RegistryEventConsumer<E>> registryEventConsumers) {
        this(defaultConfig, registryEventConsumers, Collections.emptyMap());
    }

    public AbstractRegistry(C defaultConfig, List<RegistryEventConsumer<E>> registryEventConsumers, Map<String, String> tags) {
        this.entryMap = new InMemoryRegistryStore();
        this.eventProcessor = new RegistryEventProcessor(Objects.requireNonNull(registryEventConsumers, CONSUMER_MUST_NOT_BE_NULL));
        this.registryTags = Objects.requireNonNull(tags, TAGS_MUST_NOT_BE_NULL);
        this.configurations.put(DEFAULT_CONFIG, Objects.requireNonNull(defaultConfig, CONFIG_MUST_NOT_BE_NULL));
    }

    public AbstractRegistry(C defaultConfig, List<RegistryEventConsumer<E>> registryEventConsumers, Map<String, String> tags, RegistryStore<E> registryStore) {
        this.entryMap = Objects.requireNonNull(registryStore, REGISTRY_STORE_MUST_NOT_BE_NULL);
        this.eventProcessor = new RegistryEventProcessor(Objects.requireNonNull(registryEventConsumers, CONSUMER_MUST_NOT_BE_NULL));
        this.registryTags = Objects.requireNonNull(tags, TAGS_MUST_NOT_BE_NULL);
        this.configurations.put(DEFAULT_CONFIG, Objects.requireNonNull(defaultConfig, CONFIG_MUST_NOT_BE_NULL));
    }

    protected E computeIfAbsent(String name, Supplier<E> supplier) {
        return (E)this.entryMap.computeIfAbsent(Objects.requireNonNull(name, NAME_MUST_NOT_BE_NULL), (? super String k) -> {
            Object entry = supplier.get();
            this.eventProcessor.processEvent(new EntryAddedEvent(entry));
            return entry;
        });
    }

    @Override
    public Optional<E> find(String name) {
        return this.entryMap.find(name);
    }

    @Override
    public Optional<E> remove(String name) {
        Optional<E> removedEntry = this.entryMap.remove(name);
        removedEntry.ifPresent(entry -> this.eventProcessor.processEvent(new EntryRemovedEvent<Object>(entry)));
        return removedEntry;
    }

    @Override
    public Optional<E> replace(String name, E newEntry) {
        Optional<E> replacedEntry = this.entryMap.replace(name, newEntry);
        replacedEntry.ifPresent(oldEntry -> this.eventProcessor.processEvent(new EntryReplacedEvent<Object>(oldEntry, newEntry)));
        return replacedEntry;
    }

    @Override
    public void addConfiguration(String configName, C configuration) {
        if (configName.equals(DEFAULT_CONFIG)) {
            throw new IllegalArgumentException("You cannot use 'default' as a configuration name as it is preserved for default configuration");
        }
        this.configurations.put(configName, configuration);
    }

    @Override
    public Optional<C> getConfiguration(String configName) {
        return Optional.ofNullable(this.configurations.get(configName));
    }

    @Override
    public C removeConfiguration(String configName) {
        if (configName.equals(DEFAULT_CONFIG)) {
            throw new IllegalArgumentException("You cannot remove the default configuration");
        }
        return (C)this.configurations.remove(configName);
    }

    @Override
    public C getDefaultConfig() {
        return (C)this.configurations.get(DEFAULT_CONFIG);
    }

    @Override
    public Map<String, String> getTags() {
        return this.registryTags;
    }

    @Override
    public Registry.EventPublisher<E> getEventPublisher() {
        return this.eventProcessor;
    }

    protected Map<String, String> getAllTags(Map<String, String> tags) {
        HashMap<String, String> allTags = new HashMap<String, String>(Objects.requireNonNull(this.registryTags, TAGS_MUST_NOT_BE_NULL));
        allTags.putAll(tags);
        return allTags;
    }

    private class RegistryEventProcessor
    extends EventProcessor<RegistryEvent>
    implements EventConsumer<RegistryEvent>,
    Registry.EventPublisher<E> {
        private RegistryEventProcessor() {
        }

        private RegistryEventProcessor(List<RegistryEventConsumer<E>> registryEventConsumers) {
            registryEventConsumers.forEach(consumer -> {
                this.onEntryAdded(consumer::onEntryAddedEvent);
                this.onEntryRemoved(consumer::onEntryRemovedEvent);
                this.onEntryReplaced(consumer::onEntryReplacedEvent);
            });
        }

        @Override
        public Registry.EventPublisher<E> onEntryAdded(EventConsumer<EntryAddedEvent<E>> onSuccessEventConsumer) {
            this.registerConsumer(EntryAddedEvent.class.getName(), onSuccessEventConsumer);
            return this;
        }

        @Override
        public Registry.EventPublisher<E> onEntryRemoved(EventConsumer<EntryRemovedEvent<E>> onErrorEventConsumer) {
            this.registerConsumer(EntryRemovedEvent.class.getName(), onErrorEventConsumer);
            return this;
        }

        @Override
        public Registry.EventPublisher<E> onEntryReplaced(EventConsumer<EntryReplacedEvent<E>> onStateTransitionEventConsumer) {
            this.registerConsumer(EntryReplacedEvent.class.getName(), onStateTransitionEventConsumer);
            return this;
        }

        @Override
        public void consumeEvent(RegistryEvent event) {
            super.processEvent(event);
        }
    }
}

