/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.webmodules.webapp.webfilters.legacy;

import io.vertx.core.http.HttpServerRequest;
import java.util.concurrent.CompletableFuture;
import net.bluemind.webmodule.server.handlers.TemporaryRedirectHandler;
import net.bluemind.webmodules.webapp.webfilters.legacy.IFilterChainLink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractFilterChainLink
implements IFilterChainLink {
    private IFilterChainLink next;
    private final String url;
    private static final Logger logger = LoggerFactory.getLogger(AbstractFilterChainLink.class);

    public AbstractFilterChainLink(String string) {
        this.url = string;
    }

    @Override
    public IFilterChainLink setNext(IFilterChainLink iFilterChainLink) {
        if (this.next != null) {
            this.next.setNext(iFilterChainLink);
        } else {
            this.next = iFilterChainLink;
        }
        return this;
    }

    @Override
    public void handle(HttpServerRequest httpServerRequest, CompletableFuture<HttpServerRequest> completableFuture) {
        if (this.isResponsible(httpServerRequest)) {
            this.redirect(httpServerRequest, completableFuture);
        } else if (this.next != null) {
            this.next.handle(httpServerRequest, completableFuture);
        }
    }

    protected abstract void redirect(HttpServerRequest var1, CompletableFuture<HttpServerRequest> var2);

    protected void goToApp(HttpServerRequest httpServerRequest, CompletableFuture<HttpServerRequest> completableFuture) {
        completableFuture.complete(httpServerRequest);
    }

    protected void goToWebApp(HttpServerRequest httpServerRequest, CompletableFuture<HttpServerRequest> completableFuture) {
        String string = httpServerRequest.headers().get("BMUserId");
        String string2 = httpServerRequest.headers().get("BMUserDomainId");
        logger.info("Redirecting from {} to {} for user {} on domain {}", new Object[]{httpServerRequest.path(), this.url, string, string2});
        new TemporaryRedirectHandler(this.url).handle(httpServerRequest);
        completableFuture.complete(null);
    }
}

