<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2017
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
namespace BM;
require_once 'GlobalEnv.php';

/**
 * Implementation of net.bluemind.mailbox.api.IMailboxes.
 */

class MailboxesClient {

  protected $base;
  protected $sid;
  protected $domainUid;

  /*
   * Constructor.
   *
   * @param base
   * @param sid
   * @param domainUid
   *
   */
  public function __construct($base, $sid , $domainUid) {
    $this->sid = $sid;
    $this->base = $base."/api/mailboxes/{domainUid}";
    $this->domainUid = $domainUid;
    $this->base = str_replace("{domainUid}", urlencode($domainUid), $this->base);
  }


  /*
   * @param rule
   * @return
   */
  public function addDomainRule( $rule  ) {
    $postUri = "/_rules";
    $method = "PUT";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $rule;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @param rule
   * @return
   */
  public function addMailboxRule( $mailboxUid ,  $rule  ) {
    $postUri = "/{mailboxUid}/_rules";
    $method = "PUT";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $rule;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @param position
   * @param anchorId
   * @param rule
   * @return
   */
  public function addMailboxRuleRelative( $mailboxUid ,  $position ,  $anchorId ,  $rule  ) {
    $postUri = "/{mailboxUid}/_rules/{position}/{anchorId}";
    $method = "PUT";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);
    $postUri = str_replace("{position}", urlencode($position), $postUri);
    $postUri = str_replace("{anchorId}", urlencode($anchorId), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $rule;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param email
   * @return
   */
  public function byEmail( $email  ) {
    $postUri = "/_byemail";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array(
      "email" => $email);

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param name
   * @return
   */
  public function byName( $name  ) {
    $postUri = "/_byname";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array(
      "name" => $name);

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param email
   * @return
   */
  public function byRouting( $email  ) {
    $postUri = "/_byRouting";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array(
      "email" => $email);

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param mailbox
   * @return
   */
  public function create( $uid ,  $mailbox  ) {
    $postUri = "/{uid}";
    $method = "PUT";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $mailbox;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function delete_( $uid  ) {
    $postUri = "/{uid}";
    $method = "DELETE";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param id
   * @return
   */
  public function deleteDomainRule( $id  ) {
    $postUri = "/_rules/{id}";
    $method = "DELETE";

    $postUri = str_replace("{id}", urlencode($id), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @param id
   * @return
   */
  public function deleteMailboxRule( $mailboxUid ,  $id  ) {
    $postUri = "/{mailboxUid}/_rules/{id}";
    $method = "DELETE";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);
    $postUri = str_replace("{id}", urlencode($id), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getComplete( $uid  ) {
    $postUri = "/{uid}/complete";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @return
   */
  public function getDomainFilter() {
    $postUri = "/_filter";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param id
   * @return
   */
  public function getDomainRule( $id  ) {
    $postUri = "/_rules/{id}";
    $method = "GET";

    $postUri = str_replace("{id}", urlencode($id), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @return
   */
  public function getDomainRules() {
    $postUri = "/_rules";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @return
   */
  public function getMailboxAccessControlList( $mailboxUid  ) {
    $postUri = "/{mailboxUid}/_acls";
    $method = "GET";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getMailboxConfig( $uid  ) {
    $postUri = "/{uid}/_config";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @return
   */
  public function getMailboxDelegationRule( $mailboxUid  ) {
    $postUri = "/{mailboxUid}/_delegationRule";
    $method = "GET";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @return
   */
  public function getMailboxFilter( $mailboxUid  ) {
    $postUri = "/{mailboxUid}/_filter";
    $method = "GET";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @return
   */
  public function getMailboxForwarding( $mailboxUid  ) {
    $postUri = "/{mailboxUid}/_forwarding";
    $method = "GET";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @return
   */
  public function getMailboxQuota( $uid  ) {
    $postUri = "/{uid}/_quota";
    $method = "GET";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @param id
   * @return
   */
  public function getMailboxRule( $mailboxUid ,  $id  ) {
    $postUri = "/{mailboxUid}/_rules/{id}";
    $method = "GET";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);
    $postUri = str_replace("{id}", urlencode($id), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @return
   */
  public function getMailboxRules( $mailboxUid  ) {
    $postUri = "/{mailboxUid}/_rules";
    $method = "GET";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @param client
   * @return
   */
  public function getMailboxRulesByClient( $mailboxUid ,  $client  ) {
    $postUri = "/{mailboxUid}/_rulesByClient";
    $method = "GET";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array(
      "client" => $client);

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @return
   */
  public function getMailboxVacation( $mailboxUid  ) {
    $postUri = "/{mailboxUid}/_vacation";
    $method = "GET";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @return
   */
  public function getUnreadMessagesCount() {
    $postUri = "/_unread";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @return
   */
  public function list_() {
    $postUri = "/_list";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @return
   */
  public function listUids() {
    $postUri = "/_listUids";
    $method = "GET";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @param id
   * @param direction
   * @return
   */
  public function moveMailboxRule( $mailboxUid ,  $id ,  $direction  ) {
    $postUri = "/{mailboxUid}/_rules/{id}/{direction}";
    $method = "POST";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);
    $postUri = str_replace("{id}", urlencode($id), $postUri);
    $postUri = str_replace("{direction}", urlencode($direction), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @param id
   * @param position
   * @param anchorId
   * @return
   */
  public function moveMailboxRuleRelative( $mailboxUid ,  $id ,  $position ,  $anchorId  ) {
    $postUri = "/{mailboxUid}/_rules/{id}/{position}/{anchorId}";
    $method = "POST";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);
    $postUri = str_replace("{id}", urlencode($id), $postUri);
    $postUri = str_replace("{position}", urlencode($position), $postUri);
    $postUri = str_replace("{anchorId}", urlencode($anchorId), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uids
   * @return
   */
  public function multipleGet( $uids  ) {
    $postUri = "/_mget";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $uids;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param filter
   * @return
   */
  public function setDomainFilter( $filter  ) {
    $postUri = "/_filter";
    $method = "POST";


    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $filter;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @param accessControlEntries
   * @return
   */
  public function setMailboxAccessControlList( $mailboxUid ,  $accessControlEntries  ) {
    $postUri = "/{mailboxUid}/_acls";
    $method = "POST";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $accessControlEntries;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @param delegationRule
   * @return
   */
  public function setMailboxDelegationRule( $mailboxUid ,  $delegationRule  ) {
    $postUri = "/{mailboxUid}/_delegationRule";
    $method = "POST";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $delegationRule;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @param filter
   * @return
   */
  public function setMailboxFilter( $mailboxUid ,  $filter  ) {
    $postUri = "/{mailboxUid}/_filter";
    $method = "POST";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $filter;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @param forwarding
   * @return
   */
  public function setMailboxForwarding( $mailboxUid ,  $forwarding  ) {
    $postUri = "/{mailboxUid}/_forwarding";
    $method = "POST";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $forwarding;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @param vacation
   * @return
   */
  public function setMailboxVacation( $mailboxUid ,  $vacation  ) {
    $postUri = "/{mailboxUid}/_vacation";
    $method = "POST";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $vacation;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param uid
   * @param mailbox
   * @return
   */
  public function update( $uid ,  $mailbox  ) {
    $postUri = "/{uid}";
    $method = "POST";

    $postUri = str_replace("{uid}", urlencode($uid), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $mailbox;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param id
   * @param rule
   * @return
   */
  public function updateDomainRule( $id ,  $rule  ) {
    $postUri = "/_rules/{id}";
    $method = "POST";

    $postUri = str_replace("{id}", urlencode($id), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $rule;
    return $this->execute($url, $queryParam, $body, $method);
  }

  /*
   * @param mailboxUid
   * @param id
   * @param rule
   * @return
   */
  public function updateMailboxRule( $mailboxUid ,  $id ,  $rule  ) {
    $postUri = "/{mailboxUid}/_rules/{id}";
    $method = "POST";

    $postUri = str_replace("{mailboxUid}", urlencode($mailboxUid), $postUri);
    $postUri = str_replace("{id}", urlencode($id), $postUri);

    $url = $this->base.$postUri;

    $queryParam = array();

    $body = null;
    $body = $rule;
    return $this->execute($url, $queryParam, $body, $method);
  }


  /*
   * Execute the request
   *
   * @param url
   * @param data
   * @param body
   */
  private function execute($url, $queryParam, $body, $method) {

    $curl = curl_init();

    $headers = array();
    array_push($headers, 'X-BM-ApiKey: '.$this->sid);

    if (sizeof($queryParam) > 0) {
      $url .= '?'.http_build_query($queryParam);
    }

    curl_setopt_array($curl, GlobalEnv::$curlOptions + array(
      CURLOPT_URL => $url,
      CURLOPT_HTTPHEADER => $headers,
      CURLOPT_CUSTOMREQUEST => $method)
    );

    if ($method == 'POST') {
      curl_setopt($curl, CURLOPT_POST, TRUE);
      curl_setopt($curl, CURLOPT_POSTFIELDS, array());
    }

    if (is_resource($body)) {
      if ($method == 'PUT') {
        curl_setopt($curl, CURLOPT_PUT, TRUE);
      }
      $size = fstat($body)['size'];
      curl_setopt($curl, CURLOPT_INFILE, $body);
      curl_setopt($curl, CURLOPT_INFILESIZE, $size);
    } else {
      if (is_object($body) && method_exists($body, 'serialize')) {
        $body = $body->serialize();
      } else if (is_object($body)) {
        $body = json_encode($body);
      } else if (is_array($body)) {
        $body = json_encode($body);
      } else if (is_string($body)) {
        $body = json_encode($body);
      }
      $size = strlen($body);
      array_push($headers, 'Content-Type: application/json');
      array_push($headers, 'Content-Length: '.$size);
      curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
      curl_setopt($curl, CURLOPT_POSTFIELDS, $body);
    }

    $resp = curl_exec($curl);
    if ($resp === false) {
      throw new \Exception(curl_error($curl));
    } 
    curl_close($curl);
    if (!$resp) {
      return;
    }
    $js = json_decode($resp);
    if ($js === NULL) {
      return $resp;
    }
    if (isset($js->errorCode)) {
      throw new \Exception($js->errorCode . ': ' . (isset($js->message) ? ' : ' . $js->message : ''));
    }
    return $js;
  }

}
