<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * MailFilterRule.
 */
class MailFilterRule  {

  /*
   * @type Long
   */
  public $id;

  /*
   * @type String
   */
  public $client;

  /*
   * @type MailFilterRuleType
   */
  public $type;

  /*
   * @type MailFilterRuleTrigger
   */
  public $trigger;

  /*
   * @type boolean
   */
  public $deferred;

  /*
   * @type boolean
   */
  public $active;

  /*
   * @type String
   */
  public $name;

  /*
   * @type Map
   */
  public $clientProperties;

  /*
   * @type List
   */
  public $conditions;

  /*
   * @type List
   */
  public $actions;

  /*
   * @type boolean
   */
  public $stop;

  /*
   * Constructor
   */
  public function __construct() {
    $this->id = null;
    $this->client = "";
    $this->deferred = false;
    $this->active = false;
    $this->name = "";
    $this->clientProperties = array();
    $this->conditions =  array();
    $this->actions =  array();
    $this->stop = false;
  }

  public function toMap() {
    $data = array(    
        "id" => empty($this->id) ? null : $this->id,    
        "client" => empty($this->client) ? null : $this->client,    
        "type" => empty($this->type) ? null : $this->type,    
        "trigger" => empty($this->trigger) ? null : $this->trigger,    
        "deferred" => empty($this->deferred) ? null : $this->deferred,    
        "active" => empty($this->active) ? null : $this->active,    
        "name" => empty($this->name) ? null : $this->name,    
        "clientProperties" => empty($this->clientProperties) ? null : $this->clientProperties,    
        "conditions" => empty($this->conditions) ? null : $this->conditions,    
        "actions" => empty($this->actions) ? null : $this->actions,    
        "stop" => empty($this->stop) ? null : $this->stop);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
