/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.eas.validation.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;

import com.google.common.base.Throwables;

public class BundleInput implements LSInput {

	private static final Logger logger = LoggerFactory.getLogger(BundleInput.class);

	private URL url;
	private String type;
	private String namespaceURI;
	private String baseURI;
	private String systemId;
	private String publicId;

	public BundleInput(URL u, String type, String namespaceURI, String publicId, String systemId, String baseURI) {
		this.url = u;
		this.type = type;
		this.namespaceURI = namespaceURI;
		this.publicId = publicId;
		this.systemId = systemId;
		this.baseURI = baseURI;
		logger.debug("type: {}, nsUrl: {}", this.type, this.namespaceURI);
	}

	@Override
	public Reader getCharacterStream() {
		logger.debug("{} getCharacterStream", systemId);
		return null;
	}

	@Override
	public void setCharacterStream(Reader characterStream) {
	}

	@Override
	public InputStream getByteStream() {
		logger.debug("{} getByteStream", systemId);
		try {
			return url.openStream();
		} catch (IOException e) {
			throw Throwables.propagate(e);
		}
	}

	@Override
	public void setByteStream(InputStream byteStream) {
	}

	@Override
	public String getStringData() {
		logger.debug("getStringData {}", systemId);
		return null;
	}

	@Override
	public void setStringData(String stringData) {
		logger.info("setStringData: {}", stringData);
	}

	@Override
	public String getSystemId() {
		return systemId;
	}

	@Override
	public void setSystemId(String systemId) {
		// TODO Auto-generated method stub

	}

	@Override
	public String getPublicId() {
		return publicId;
	}

	@Override
	public void setPublicId(String publicId) {
		// TODO Auto-generated method stub

	}

	@Override
	public String getBaseURI() {
		return baseURI;
	}

	@Override
	public void setBaseURI(String baseURI) {
		// TODO Auto-generated method stub

	}

	@Override
	public String getEncoding() {
		return "utf-8";
	}

	@Override
	public void setEncoding(String encoding) {
	}

	@Override
	public boolean getCertifiedText() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void setCertifiedText(boolean certifiedText) {
	}

}
