<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ImportMailboxItemSet.
 */
class ImportMailboxItemSet  {

  /*
   * @type long
   */
  public $mailboxFolderId;

  /*
   * @type List
   */
  public $ids;

  /*
   * @type boolean
   */
  public $deleteFromSource;

  /*
   * Constructor
   */
  public function __construct() {
    $this->mailboxFolderId = 0;
    $this->ids =  array();
    $this->deleteFromSource = false;
  }

  public function toMap() {
    $data = array(    
        "mailboxFolderId" => empty($this->mailboxFolderId) ? null : $this->mailboxFolderId,    
        "ids" => empty($this->ids) ? null : $this->ids,    
        "deleteFromSource" => empty($this->deleteFromSource) ? null : $this->deleteFromSource);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
