/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.user.cql.store.factories;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.rest.BmContext;
import net.bluemind.cql.CqlSessions;
import net.bluemind.cql.persistence.CqlRepositoryFactory;
import net.bluemind.repository.provider.IContainerBoundFactory;
import net.bluemind.user.cql.store.CqlUserSettingsStore;
import net.bluemind.user.repository.IUserSettingsStore;

public class UserSettingsFactory extends CqlRepositoryFactory<IUserSettingsStore>
		implements IContainerBoundFactory<IUserSettingsStore> {

	@Override
	public Class<IUserSettingsStore> factoryClass() {
		return IUserSettingsStore.class;
	}

	@Override
	public IUserSettingsStore instance(BmContext context, Container container) throws ServerFault {
		return new CqlUserSettingsStore(CqlSessions.forKeyspace("core"), container);
	}

}
