<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * LogEntry.
 */
class LogEntry  {

  /*
   * @type long
   */
  public $timestamp;

  /*
   * @type LogLevel
   */
  public $severity;

  /*
   * @type String
   */
  public $locale;

  /*
   * @type String
   */
  public $content;

  /*
   * @type int
   */
  public $offset;

  /*
   * Constructor
   */
  public function __construct() {
    $this->timestamp = 0;
    $this->locale = "";
    $this->content = "";
    $this->offset = 0;
  }

  public function toMap() {
    $data = array(    
        "timestamp" => empty($this->timestamp) ? null : $this->timestamp,    
        "severity" => empty($this->severity) ? null : $this->severity,    
        "locale" => empty($this->locale) ? null : $this->locale,    
        "content" => empty($this->content) ? null : $this->content,    
        "offset" => empty($this->offset) ? null : $this->offset);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
