/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.notes.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VNotesQueryGwtSerDer implements GwtSerDer<net.bluemind.notes.api.VNotesQuery> {

	public VNotesQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.notes.api.VNotesQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.notes.api.VNotesQuery ret = new net.bluemind.notes.api.VNotesQuery();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.notes.api.VNotesQuery ret, JSONObject json) {
		JSONValue ownerJSON = json.get("owner");
		ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		JSONValue containersJSON = json.get("containers");
		ret.containers =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(containersJSON);
		JSONValue vnoteQueryJSON = json.get("vnoteQuery");
		ret.vnoteQuery =  new net.bluemind.notes.api.gwt.serder.VNoteQueryGwtSerDer().deserialize(vnoteQueryJSON);
	}

	public void deserializeTo(net.bluemind.notes.api.VNotesQuery ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("owner")) {
			JSONValue ownerJSON = json.get("owner");
			ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		}
		if (!childPropertiesToIgnore.contains("containers")) {
			JSONValue containersJSON = json.get("containers");
			ret.containers =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(containersJSON);
		}
		if (!childPropertiesToIgnore.contains("vnoteQuery")) {
			JSONValue vnoteQueryJSON = json.get("vnoteQuery");
			ret.vnoteQuery =  new net.bluemind.notes.api.gwt.serder.VNoteQueryGwtSerDer().deserialize(vnoteQueryJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.notes.api.VNotesQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.notes.api.VNotesQuery o, JSONObject ret) {

		ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		ret.put("containers",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.containers ));
		ret.put("vnoteQuery",  new net.bluemind.notes.api.gwt.serder.VNoteQueryGwtSerDer().serialize( o.vnoteQuery ));
	}

	public void serializeTo(net.bluemind.notes.api.VNotesQuery o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("owner")) {
			ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		}
		if (!childPropertiesToIgnore.contains("containers")) {
			ret.put("containers",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.containers ));
		}
		if (!childPropertiesToIgnore.contains("vnoteQuery")) {
			ret.put("vnoteQuery",  new net.bluemind.notes.api.gwt.serder.VNoteQueryGwtSerDer().serialize( o.vnoteQuery ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}