/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.notes.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsVNoteColor extends JavaScriptObject {

	protected JsVNoteColor() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsVNoteColor BLUE()
	/*-{
		return "BLUE";
	}-*/;

	public static final native JsVNoteColor GREEN()
	/*-{
		return "GREEN";
	}-*/;

	public static final native JsVNoteColor PINK()
	/*-{
		return "PINK";
	}-*/;

	public static final native JsVNoteColor YELLOW()
	/*-{
		return "YELLOW";
	}-*/;

	public static final native JsVNoteColor WHITE()
	/*-{
		return "WHITE";
	}-*/;

	public static final JsVNoteColor create(net.bluemind.notes.api.VNote.Color value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case BLUE:
				return BLUE();
			case GREEN:
				return GREEN();
			case PINK:
				return PINK();
			case YELLOW:
				return YELLOW();
			case WHITE:
				return WHITE();
			default:
				return null;
			}
		}
	}
}