/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.cti.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsStatusType extends JavaScriptObject {

	protected JsStatusType() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsStatusType DoNotDisturb()
	/*-{
		return "DoNotDisturb";
	}-*/;

	public static final native JsStatusType Available()
	/*-{
		return "Available";
	}-*/;

	public static final native JsStatusType Busy()
	/*-{
		return "Busy";
	}-*/;

	public static final native JsStatusType Offline()
	/*-{
		return "Offline";
	}-*/;

	public static final JsStatusType create(net.bluemind.cti.api.Status.Type value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case DoNotDisturb:
				return DoNotDisturb();
			case Available:
				return Available();
			case Busy:
				return Busy();
			case Offline:
				return Offline();
			default:
				return null;
			}
		}
	}
}