/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.cti.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsStatusPhoneState extends JavaScriptObject {

	protected JsStatusPhoneState() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsStatusPhoneState Unknown()
	/*-{
		return "Unknown";
	}-*/;

	public static final native JsStatusPhoneState Available()
	/*-{
		return "Available";
	}-*/;

	public static final native JsStatusPhoneState DoNotDisturb()
	/*-{
		return "DoNotDisturb";
	}-*/;

	public static final native JsStatusPhoneState Ringing()
	/*-{
		return "Ringing";
	}-*/;

	public static final native JsStatusPhoneState Busy()
	/*-{
		return "Busy";
	}-*/;

	public static final native JsStatusPhoneState OnHold()
	/*-{
		return "OnHold";
	}-*/;

	public static final JsStatusPhoneState create(net.bluemind.cti.api.Status.PhoneState value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case Unknown:
				return Unknown();
			case Available:
				return Available();
			case DoNotDisturb:
				return DoNotDisturb();
			case Ringing:
				return Ringing();
			case Busy:
				return Busy();
			case OnHold:
				return OnHold();
			default:
				return null;
			}
		}
	}
}