/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.cti.api.gwt.endpoint;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.URL;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.lang.Long;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.api.Stream;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class ComputerTelephonyIntegrationSockJsEndpoint implements net.bluemind.cti.api.IComputerTelephonyIntegrationAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public ComputerTelephonyIntegrationSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/cti/{domainUid}/{userUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}", URL.encodePathSegment(pathVars[0]));
				uri_ = uri_.replace("{userUid}", URL.encodePathSegment(pathVars[1]));
		
		baseUri = uri_;
	}

	public ComputerTelephonyIntegrationSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void dial(String number, final AsyncHandler<Void> handler) {
		String postUri = "/dial";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("number", URL.encodeQueryString(""+number));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void forward(String component, String phoneNumber, final AsyncHandler<Void> handler) {
		String postUri = "/forward/{component}";

		postUri = postUri.replace("{component}", URL.encodePathSegment(""+component));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		params.put("phoneNumber", URL.encodeQueryString(""+phoneNumber));
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void getStatus(final AsyncHandler<net.bluemind.cti.api.Status> handler) {
		String postUri = "/status";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.cti.api.Status>(handler) {
					@Override
			protected net.bluemind.cti.api.Status handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.cti.api.gwt.serder.StatusGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void getUserEmails(final AsyncHandler<List<String>> handler) {
		String postUri = "/users";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<List<String>>(handler) {
					@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue );
			}
		});

	}


	@Override
	public void setStatus(String component, net.bluemind.cti.api.Status status, final AsyncHandler<Void> handler) {
		String postUri = "/status/{component}";

		postUri = postUri.replace("{component}", URL.encodePathSegment(""+component));
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.cti.api.gwt.serder.StatusGwtSerDer().serialize( status);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}

	public net.bluemind.cti.api.IComputerTelephonyIntegrationPromise promiseApi() {
		return new ComputerTelephonyIntegrationEndpointPromise(this);
	}

}
