/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class OrgUnitGwtSerDer implements GwtSerDer<net.bluemind.directory.api.OrgUnit> {

	public OrgUnitGwtSerDer( ) {
	}

	@Override
	public net.bluemind.directory.api.OrgUnit deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.directory.api.OrgUnit ret = new net.bluemind.directory.api.OrgUnit();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.directory.api.OrgUnit ret, JSONObject json) {
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue parentUidJSON = json.get("parentUid");
		ret.parentUid =  GwtSerDerUtils.STRING.deserialize(parentUidJSON);
	}

	public void deserializeTo(net.bluemind.directory.api.OrgUnit ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		}
		if (!childPropertiesToIgnore.contains("parentUid")) {
			JSONValue parentUidJSON = json.get("parentUid");
			ret.parentUid =  GwtSerDerUtils.STRING.deserialize(parentUidJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.directory.api.OrgUnit o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.directory.api.OrgUnit o, JSONObject ret) {

		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("parentUid",  GwtSerDerUtils.STRING.serialize( o.parentUid ));
	}

	public void serializeTo(net.bluemind.directory.api.OrgUnit o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		}
		if (!childPropertiesToIgnore.contains("parentUid")) {
			ret.put("parentUid",  GwtSerDerUtils.STRING.serialize( o.parentUid ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}