package net.bluemind.exchange.mapi.persistence.pclcache;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

import net.bluemind.core.jdbc.Columns;
import net.bluemind.core.jdbc.JdbcAbstractStore.EntityPopulator;
import net.bluemind.core.jdbc.JdbcAbstractStore.StatementValues;
import net.bluemind.exchange.mapi.api.MapiPCLCacheEntry;

public class MapiPCLCacheColumns {
	public static final Columns cols = Columns.create()//
			.col("replica_guid")//
			.col("container_item_id")//
			.col("modification_nano")//
			.col("server_replica_guid")//
			.col("version")//
			.col("changekey_size");

	public static StatementValues<MapiPCLCacheEntry> values(UUID replica_guid, Long globalCounter) {
		return new StatementValues<MapiPCLCacheEntry>() {

			@Override
			public int setValues(Connection con, PreparedStatement statement, int index, int currentRow,
					MapiPCLCacheEntry value) throws SQLException {
				statement.setObject(index++, replica_guid);
				statement.setLong(index++, globalCounter);
				statement.setLong(index++, value.getModificationNanos());
				statement.setObject(index++, value.getServerReplicaGuid());
				statement.setLong(index++, value.getVersion());
				statement.setShort(index++, (short) value.getChangekeySize());
				return index;
			}
		};
	}

	public static EntityPopulator<MapiPCLCacheEntry> populator() {
		return (ResultSet rs, int index, MapiPCLCacheEntry f) -> {
			index++;
			index++;
			f.setModificationNanos(rs.getLong(index++));
			f.setServerReplicaGuid(rs.getObject(index++, UUID.class));
			f.setVersion(rs.getLong(index++));
			f.setChangekeySize(rs.getShort(index++));
			return index;
		};
	}
}
