package net.bluemind.exchange.mapi.persistence.factory;

import java.util.List;

import com.google.common.annotations.VisibleForTesting;

import net.bluemind.core.api.DataSourceType;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.rest.BmContext;
import net.bluemind.exchange.mapi.persistence.pclcache.MapiPCLCacheStore;
import net.bluemind.exchange.mapi.persistence.pclcache.migration.MapiPCLCachePostgresToMapDbMigrationStore;
import net.bluemind.exchange.mapi.persistence.pclcache.migration.PclCacheMigrationDoneFlag;
import net.bluemind.exchange.mapi.repository.IMapiPCLCacheStore;
import net.bluemind.repository.provider.IStandaloneFactory;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTask;
import net.bluemind.system.api.hot.upgrade.HotUpgradeTaskFilter;
import net.bluemind.system.api.hot.upgrade.IHotUpgrade;

public class MapiPCLCacheStoreFactory implements IStandaloneFactory<IMapiPCLCacheStore> {

	public static final String MIGRATION_OPERATION_NAME = "pcl-cache-mapdb-to-postgres";
	private static Boolean migrationExist = null;

	@Override
	public Class<IMapiPCLCacheStore> factoryClass() {
		return IMapiPCLCacheStore.class;
	}

	@Override
	public DataSourceType targetRepositoryType() {
		return DataSourceType.POSTGRESQL;
	}

	@Override
	public IMapiPCLCacheStore instance(BmContext context) throws ServerFault {
		boolean migrationNotExist = !migrationExist(context);
		boolean migrationFinished = migrationFinished();

		if (migrationNotExist || migrationFinished) {
			return postgresStore(context);
		}
		return hybridStore(context);
	}

	private static boolean migrationExist(BmContext context) {
		if (migrationExist == null) {
			IHotUpgrade hotUpgradeService = context.provider().instance(IHotUpgrade.class);
			HotUpgradeTaskFilter filter = HotUpgradeTaskFilter.filter().operation(MIGRATION_OPERATION_NAME);

			List<HotUpgradeTask> migrations = hotUpgradeService.list(filter);
			if (migrations == null || migrations.isEmpty()) {
				migrationExist = false;
			} else {
				migrationExist = true;
			}
		}
		return migrationExist;
	}

	private static boolean migrationFinished() {
		return PclCacheMigrationDoneFlag.get().isAllDone();
	}

	@VisibleForTesting
	public static void resetForTests() {
		migrationExist = null;
	}

	private static MapiPCLCacheStore postgresStore(BmContext context) {
		return new MapiPCLCacheStore(context.getAllMailboxDataSource().getFirst());
	}

	private static MapiPCLCachePostgresToMapDbMigrationStore hybridStore(BmContext context) {
		return new MapiPCLCachePostgresToMapDbMigrationStore(context.getAllMailboxDataSource().getFirst());
	}

}
