/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.eas.backend.importer;

import net.bluemind.eas.backend.SyncFolder;
import net.bluemind.eas.backend.dto.CollectionIdContext;
import net.bluemind.eas.dto.sync.CollectionId;
import net.bluemind.eas.session.BackendSession;

public class HierarchyImportEntity {

	public final CollectionIdContext collectionIdContext;
	public final BackendSession backendSession;
	public final CollectionId serverId;
	public final String user;
	public SyncFolder syncFolder;
	public String folderDisplayName;

	protected HierarchyImportEntity(BackendSession backendSession, CollectionId collectionId) {
		this.collectionIdContext = new CollectionIdContext(backendSession, collectionId);
		this.backendSession = collectionIdContext.backendSession();
		this.serverId = collectionIdContext.collectionId();
		this.folderDisplayName = null;
		this.syncFolder = null;
		this.user = backendSession.getLoginAtDomain();
	}

	protected HierarchyImportEntity(BackendSession backendSession, SyncFolder syncFolder) {
		this(backendSession, syncFolder.getServerId());
		this.syncFolder = syncFolder;
		this.folderDisplayName = syncFolder.getDisplayName();
	}

	public static HierarchyImportEntity createHierarchyImportEntity(BackendSession backendSession,
			SyncFolder syncFolder) {
		return new HierarchyImportEntity(backendSession, syncFolder);
	}

	public static HierarchyImportEntity createHierarchyImportEntity(BackendSession backendSession,
			CollectionId collectionId) {
		return new HierarchyImportEntity(backendSession, collectionId);
	}

}
