/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.eas.backend.importer;

import java.util.Collection;
import java.util.List;

import net.bluemind.eas.backend.HierarchyNode;
import net.bluemind.eas.dto.base.CollectionItem;
import net.bluemind.eas.dto.type.ItemDataType;
import net.bluemind.eas.session.BackendSession;

public class ContentImportEntityForMove extends ContentImportEntity {

	public HierarchyNode srcFolder;
	public HierarchyNode dstFolder;
	public Collection<CollectionItem> items;

	public ContentImportEntityForMove(BackendSession backendSession, ItemDataType type) {
		super(backendSession, type);
	}

	public static ContentImportEntityForMove create(BackendSession backendSession, ItemDataType type, HierarchyNode srcFolder,
			HierarchyNode dstFolder, List<CollectionItem> items) {
		ContentImportEntityForMove contentEntity = new ContentImportEntityForMove(backendSession, type);
		contentEntity.srcFolder = srcFolder;
		contentEntity.dstFolder = dstFolder;
		contentEntity.items = items;
		return contentEntity;
	}

}
