/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.cql.store;

import java.sql.SQLException;
import java.util.Map;

import com.datastax.oss.driver.api.core.CqlSession;

import net.bluemind.cql.persistence.CqlAbstractStore;
import net.bluemind.dataprotect.api.RetentionPolicy;
import net.bluemind.dataprotect.repository.IRetentionPolicyStore;
import net.bluemind.system.repository.ISystemConfStore;

public class CqlRetentionStore extends CqlAbstractStore implements IRetentionPolicyStore {

	private static final String KEY = "dp_daily_retention";

	public CqlRetentionStore(CqlSession s) {
		super(s);
	}

	@Override
	public void update(RetentionPolicy rp) throws SQLException {
		voidCql("UPDATE t_system_conf SET conf = conf + ? WHERE conf_id=?", Map.of(KEY, Integer.toString(rp.daily)),
				ISystemConfStore.GLOBAL_ID);
	}

	@Override
	public RetentionPolicy get() throws SQLException {
		Map<String, String> dailyRet = unique("select conf from t_system_conf WHERE conf_id=?",
				r -> r.getMap(0, String.class, String.class), voidPop(), ISystemConfStore.GLOBAL_ID);
		RetentionPolicy rp = new RetentionPolicy();
		rp.daily = 1;
		if (dailyRet != null && dailyRet.containsKey(KEY)) {
			rp.daily = Integer.parseInt(dailyRet.get(KEY));
		}
		return rp;
	}

}
