/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2019
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.sds.dto;

import java.util.List;

public class SdsError {

	public String message;
	private List<String> guids;
	public boolean retryable;

	public SdsError() {
	}

	public SdsError(String message, boolean retryable) {
		this.message = message;
		this.retryable = retryable;
	}

	public SdsError(String message, List<String> guids, boolean retryable) {
		this(message, retryable);
		this.guids = guids;
	}

	public SdsError(String message, String guid, boolean retryable) {
		this(message, List.of(guid), retryable);
	}

	@Override
	public String toString() {
		return message + " on messages " + guids;
	}

	public boolean retryable() {
		return retryable;
	}

	public List<String> guids() {
		return guids;
	}

}
