/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.user.service.internal.cql;

import java.time.Instant;
import java.util.Collections;
import java.util.List;

import net.bluemind.core.container.model.ItemValue;
import net.bluemind.directory.api.BaseDirEntry.Kind;
import net.bluemind.directory.repository.DirEntryNG;
import net.bluemind.directory.repository.DirEntryNG.LoginCaps;
import net.bluemind.domain.api.Domain;
import net.bluemind.mailbox.api.Mailbox;
import net.bluemind.mailbox.api.Mailbox.Routing;
import net.bluemind.user.api.User;
import net.bluemind.user.persistence.security.HashFactory;
import net.bluemind.user.service.internal.UserMailboxAdapter;

public class UserDirAdapter {

	public DirEntryNG fromUser(String uid, ItemValue<Domain> dom, User u) {
		Mailbox mb = UserMailboxAdapter.create(false).asMailbox(dom.uid, uid, u);
		DirEntryNG de = new DirEntryNG();
		de.displayName = mb == null ? u.login : mb.name;
		de.mailboxName = mb == null ? u.login : mb.name;
		de.routing = mb == null ? Routing.none : mb.routing;
		de.entryUid = uid;
		de.kind = Kind.USER;
		de.emails = u.emails == null ? Collections.emptyList() : List.copyOf(u.emails);
		if (u.password != null) {
			LoginCaps lc = new LoginCaps();
			lc.passwordHash = HashFactory.getDefault().create(u.password);
			lc.lastChange = Instant.now();
			lc.mustChange = u.passwordMustChange;
			lc.neverExpires = u.passwordNeverExpires;
			de.loginCaps = lc;
		}
		return de;
	}

	public User fromEntry(DirEntryNG ng) {
		User u = new User();
		u.login = ng.mailboxName;
		u.emails = List.copyOf(ng.emails);
		u.hidden = ng.hidden;
		u.archived = ng.archived;
		u.system = ng.system;
		u.routing = ng.routing;
		return u;
	}

}
