<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * User.
 */
class User extends DirBaseValue {

  /*
   * @type String
   */
  public $login;

  /*
   * @type String
   */
  public $password;

  /*
   * @type javautilDate
   */
  public $passwordLastChange;

  /*
   * @type boolean
   */
  public $passwordMustChange;

  /*
   * @type boolean
   */
  public $passwordNeverExpires;

  /*
   * @type VCard
   */
  public $contactInfos;

  /*
   * @type MailboxRouting
   */
  public $routing;

  /*
   * @type BaseDirEntryAccountType
   */
  public $accountType;

  /*
   * @type Integer
   */
  public $quota;

  /*
   * @type String
   */
  public $mailboxCopyGuid;

  /*
   * @type Map
   */
  public $properties;

  /*
   * Constructor
   */
  public function __construct() {
  parent::__construct();    $this->login = "";
    $this->password = "";
    $this->passwordLastChange = null;
    $this->passwordMustChange = false;
    $this->passwordNeverExpires = false;
    $this->contactInfos =   new VCard();
    $this->quota = null;
    $this->mailboxCopyGuid = "";
    $this->properties = array();
  }

  public function toMap() {
    $data = array(    
        "login" => empty($this->login) ? null : $this->login,    
        "password" => empty($this->password) ? null : $this->password,    
        "passwordLastChange" => empty($this->passwordLastChange) ? null : $this->passwordLastChange,    
        "passwordMustChange" => empty($this->passwordMustChange) ? null : $this->passwordMustChange,    
        "passwordNeverExpires" => empty($this->passwordNeverExpires) ? null : $this->passwordNeverExpires,    
        "contactInfos" => empty($this->contactInfos) ? null : $this->contactInfos,    
        "routing" => empty($this->routing) ? null : $this->routing,    
        "accountType" => empty($this->accountType) ? null : $this->accountType,    
        "quota" => empty($this->quota) ? null : $this->quota,    
        "mailboxCopyGuid" => empty($this->mailboxCopyGuid) ? null : $this->mailboxCopyGuid,    
        "properties" => empty($this->properties) ? null : $this->properties);
    return $data;
  }
  
  public function serialize() {
    $parentMap =  $parentMap = parent::toMap();;
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
