/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2023
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.hollow.datamodel.producer;

import net.bluemind.addressbook.api.AddressBookDescriptor;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.directory.api.DirEntry;
import net.bluemind.directory.hollow.datamodel.producer.Value.StringValue;

public class DomainAddressBookSerializer extends DirEntrySerializer {

	private final AddressBookDescriptor addressbook;

	protected DomainAddressBookSerializer(AddressBookDescriptor addressbook, ItemValue<DirEntry> dirEntry,
			String domainUid) {
		super(dirEntry, domainUid);
		this.addressbook = addressbook;
	}

	@Override
	public Value get(Property property) {
		switch (property) {
		case DisplayName:
		case AddressBookDisplayNamePrintableAscii:
			return new StringValue(addressbook.name);
		default:
			return super.get(property);
		}
	}

}
