/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.eas.backend.bm;

import net.bluemind.eas.backend.ISettingsExporter;
import net.bluemind.eas.backend.MailboxVacation;
import net.bluemind.eas.session.BackendSession;

public class SettingsExporter implements ISettingsExporter {

	private FolderBackend folderBackend;

	public SettingsExporter(FolderBackend folderBackend) {
		this.folderBackend = folderBackend;
	}

	@Override
	public MailboxVacation getVacation(BackendSession bs) {
		return folderBackend.getVacation(bs);
	}
}
