/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.user.api.IUserExternalAccount.
 */
namespace net.bluemind.user.api
{

  public class UserExternalAccountClient : BMClient
  {
    private String domain;
    private String uid;
  
    /*
     * Constructor 
     */
    public UserExternalAccountClient(String baseUrl, String sid , String domain , String uid )
    {
      this.baseUrl = baseUrl + "/api/users/{domain}/{uid}/accounts";      
      this.sid = sid;
      this.domain = domain;
      this.baseUrl = this.baseUrl.Replace("{domain}", domain);
      this.uid = uid;
      this.baseUrl = this.baseUrl.Replace("{uid}", uid);
      this.logger = new DefaultLogger();
      this.version = "5.4.2696";
    }
    
    public void create(String system, net.bluemind.user.api.UserAccount account )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{system}";
      methodPathValue = methodPathValue.Replace("{system}", HttpUtility.UrlEncode("" + system));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.user.api.UserAccount));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, account);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String system )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{system}";
      methodPathValue = methodPathValue.Replace("{system}", HttpUtility.UrlEncode("" + system));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void deleteAll()
    {
      String methodVerb = "DELETE";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.user.api.UserAccount get(String system )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{system}";
      methodPathValue = methodPathValue.Replace("{system}", HttpUtility.UrlEncode("" + system));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.user.api.UserAccount>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.user.api.UserAccountInfo> getAll()
    {
      String methodVerb = "GET";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.user.api.UserAccountInfo>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String system, net.bluemind.user.api.UserAccount account )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{system}";
      methodPathValue = methodPathValue.Replace("{system}", HttpUtility.UrlEncode("" + system));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.user.api.UserAccount));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, account);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
