/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.todolist.api.ITodoLists.
 */
namespace net.bluemind.todolist.api
{

  public class TodoListsClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public TodoListsClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/todolists";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.4.2696";
    }
    
    public void create(String uid, net.bluemind.core.container.model.ContainerDescriptor descriptor )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.ContainerDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, descriptor);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.todolist.api.VTodo>> search(net.bluemind.todolist.api.TodoListsVTodoQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_search";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.todolist.api.TodoListsVTodoQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemContainerValue<net.bluemind.todolist.api.VTodo>>>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
