/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.system.api.hot.upgrade
{
  [DataContract(Namespace="")]
  public partial class HotUpgradeStepEvent  {
    [DataMember]
    public String step;
    
    [IgnoreDataMember]
    public net.bluemind.system.api.hot.upgrade.HotUpgradeStepEventStatus? status;
    [DataMember(Name = "status")]
    public String statusSurrogate
    {
        get
        {
            return status.HasValue ? status.ToString() : null;
        }
        set
        {
            net.bluemind.system.api.hot.upgrade.HotUpgradeStepEventStatus e;
            status = Enum.TryParse(value, true, out e) ? e : (net.bluemind.system.api.hot.upgrade.HotUpgradeStepEventStatus?)null;
        }
    }
    
    [DataMember]
    public String message;
    
    [DataMember]
    public long? date;
    
  
  }
}
