/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.system.api
{
  [DataContract(Namespace="")]
  public partial class SubscriptionInformations  {
    [DataMember]
    public String version;
    
    [DataMember]
    public String installationVersion;
    
    [DataMember]
    public String customer;
    
    [DataMember]
    public String customerCode;
    
    [DataMember]
    public String dealer;
    
    [DataMember]
    public String distributor;
    
    [IgnoreDataMember]
    public net.bluemind.system.api.SubscriptionInformationsKind? kind;
    [DataMember(Name = "kind")]
    public String kindSurrogate
    {
        get
        {
            return kind.HasValue ? kind.ToString() : null;
        }
        set
        {
            net.bluemind.system.api.SubscriptionInformationsKind e;
            kind = Enum.TryParse(value, true, out e) ? e : (net.bluemind.system.api.SubscriptionInformationsKind?)null;
        }
    }
    
    [IgnoreDataMember]
    public System.DateTime? starts;
    [DataMember(Name = "starts")]
    public String startsSurrogate
    {
      get
      {
        return (starts != null)
          ? "" + Math.Floor((((DateTime)starts) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          starts = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          starts = null;
        }
      }
    }
    
    [IgnoreDataMember]
    public System.DateTime? ends;
    [DataMember(Name = "ends")]
    public String endsSurrogate
    {
      get
      {
        return (ends != null)
          ? "" + Math.Floor((((DateTime)ends) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          ends = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          ends = null;
        }
      }
    }
    
    [DataMember]
    public Boolean valid;
    
    [DataMember]
    public String pubKeyFingerprint;
    
    [DataMember]
    public Boolean validProvider;
    
    [DataMember]
    public String fromTechVersion;
    
    [DataMember]
    public List<net.bluemind.system.api.SubscriptionInformationsInstallationIndicator> indicator = new List<net.bluemind.system.api.SubscriptionInformationsInstallationIndicator>();
    
    [DataMember]
    public List<String> contacts = new List<String>();
    
    [DataMember]
    public List<net.bluemind.system.api.SubscriptionInformationsMessage> messages = new List<net.bluemind.system.api.SubscriptionInformationsMessage>();
    
  
  }
}
