/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.system.api.IInternalCredentials.
 */
namespace net.bluemind.system.api
{

  public class InternalCredentialsClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public InternalCredentialsClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/credentials/{domainUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "5.4.2696";
    }
    
    public void addUserCredential(String userUid, net.bluemind.system.api.Credential credential )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/user/{userUid}";
      methodPathValue = methodPathValue.Replace("{userUid}", HttpUtility.UrlEncode("" + userUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.system.api.Credential));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, credential);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void addUserCredentials(String userUid, List<net.bluemind.system.api.Credential> credentials )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/user/{userUid}/_credentials";
      methodPathValue = methodPathValue.Replace("{userUid}", HttpUtility.UrlEncode("" + userUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<net.bluemind.system.api.Credential>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, credentials);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public String getDomainCredentialById(String credentialId )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{credentialId}";
      methodPathValue = methodPathValue.Replace("{credentialId}", HttpUtility.UrlEncode("" + credentialId));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential> getObfuscatedUserCredentials(String userUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/user/{userUid}";
      methodPathValue = methodPathValue.Replace("{userUid}", HttpUtility.UrlEncode("" + userUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.system.api.Credential> getUserCredentials(String userUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/user/{userUid}/plain";
      methodPathValue = methodPathValue.Replace("{userUid}", HttpUtility.UrlEncode("" + userUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.system.api.Credential>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void removeUserCredential(String userUid, String credentialId )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/user/{userUid}/{credentialId}";
      methodPathValue = methodPathValue.Replace("{userUid}", HttpUtility.UrlEncode("" + userUid));
      methodPathValue = methodPathValue.Replace("{credentialId}", HttpUtility.UrlEncode("" + credentialId));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
