/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.system.api.IGlobalSettings.
 */
namespace net.bluemind.system.api
{

  public class GlobalSettingsClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public GlobalSettingsClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/global_settings";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.4.2696";
    }
    
    public void delete(String key )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("key", key.ToString());

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public Dictionary<String, String> get()
    {
      String methodVerb = "GET";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<Dictionary<String, String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void set(Dictionary<String, String> settings )
    {
      String methodVerb = "PUT";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = new JavaScriptSerializer().Serialize(settings);
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
