/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.server.api.IServer.
 */
namespace net.bluemind.server.api
{

  public class ServerClient : BMClient
  {
    private String containerUid;
  
    /*
     * Constructor 
     */
    public ServerClient(String baseUrl, String sid , String containerUid )
    {
      this.baseUrl = baseUrl + "/api/servers/{containerUid}";      
      this.sid = sid;
      this.containerUid = containerUid;
      this.baseUrl = this.baseUrl.Replace("{containerUid}", containerUid);
      this.logger = new DefaultLogger();
      this.version = "5.4.2696";
    }
    
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>> allComplete()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_complete";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void assign(String serverUid, String domainUid, String tag )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{domainUid}/assignments/{serverUid}/_assign";
      methodPathValue = methodPathValue.Replace("{serverUid}", HttpUtility.UrlEncode("" + serverUid));
      methodPathValue = methodPathValue.Replace("{domainUid}", HttpUtility.UrlEncode("" + domainUid));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("tag", tag.ToString());

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> byAssignment(String domainUid, String tag )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{domainUid}/byAssignment";
      methodPathValue = methodPathValue.Replace("{domainUid}", HttpUtility.UrlEncode("" + domainUid));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("tag", tag.ToString());

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef create(String uid, net.bluemind.server.api.Server srv )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.server.api.Server));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, srv);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.server.api.Assignment> getAssignments(String domainUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{domainUid}/assignments";
      methodPathValue = methodPathValue.Replace("{domainUid}", HttpUtility.UrlEncode("" + domainUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.server.api.Assignment>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server> getComplete(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/complete";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.server.api.Server>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.server.api.Assignment> getServerAssignments(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/serverAssignments";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.server.api.Assignment>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.server.api.CommandStatus getStatus(String uid, String @ref )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/command_status";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("ref", @ref.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.server.api.CommandStatus>(methodPathValue, queryParams, body, methodVerb);
    }
    public byte[] readFile(String uid, String path )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/fs/{path}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));
      methodPathValue = methodPathValue.Replace("{path}", HttpUtility.UrlEncode("" + path));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<byte[]>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef setTags(String uid, List<String> tags )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/tags";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, tags);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public String submit(String uid, String[] argv )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/submit_command";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String[]));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, argv);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.server.api.CommandStatus submitAndWait(String uid, String[] argv )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/submit_command_and_wait";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String[]));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, argv);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.server.api.CommandStatus>(methodPathValue, queryParams, body, methodVerb);
    }
    public void unassign(String serverUid, String domainUid, String tag )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{domainUid}/assignments/{serverUid}/_unassign";
      methodPathValue = methodPathValue.Replace("{serverUid}", HttpUtility.UrlEncode("" + serverUid));
      methodPathValue = methodPathValue.Replace("{domainUid}", HttpUtility.UrlEncode("" + domainUid));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("tag", tag.ToString());

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.task.api.TaskRef update(String uid, net.bluemind.server.api.Server srv )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.server.api.Server));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, srv);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.task.api.TaskRef>(methodPathValue, queryParams, body, methodVerb);
    }
    public void writeFile(String uid, String path, byte[] content )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}/fs/{path}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));
      methodPathValue = methodPathValue.Replace("{path}", HttpUtility.UrlEncode("" + path));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = content;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
