/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.scheduledjob.api
{
  [DataContract(Namespace="")]
  public partial class JobDomainStatus  {
    [DataMember]
    public String domain;
    
    [IgnoreDataMember]
    public net.bluemind.scheduledjob.api.JobExitStatus? status;
    [DataMember(Name = "status")]
    public String statusSurrogate
    {
        get
        {
            return status.HasValue ? status.ToString() : null;
        }
        set
        {
            net.bluemind.scheduledjob.api.JobExitStatus e;
            status = Enum.TryParse(value, true, out e) ? e : (net.bluemind.scheduledjob.api.JobExitStatus?)null;
        }
    }
    
  
  }
}
