/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.scheduledjob.api.IJob.
 */
namespace net.bluemind.scheduledjob.api
{

  public class JobClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public JobClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/scheduledjobs";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.4.2696";
    }
    
    public void cancel(String jobId, String domainName )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/_cancel/{jobId}";
      methodPathValue = methodPathValue.Replace("{jobId}", HttpUtility.UrlEncode("" + jobId));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("domainName", domainName.ToString());

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void deleteExecution(int? jobExecutionId )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/_deleteExecution";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("jobExecutionId", jobExecutionId.ToString());

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void deleteExecutions(List<int?> executions )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/_deleteExecutions";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<int?>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, executions);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.scheduledjob.api.Job getJobFromId(String jobId )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_job/{jobId}";
      methodPathValue = methodPathValue.Replace("{jobId}", HttpUtility.UrlEncode("" + jobId));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.scheduledjob.api.Job>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.scheduledjob.api.LogEntry> getLogs(net.bluemind.scheduledjob.api.JobExecution jobExecution, int? offset )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_logs";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("offset", offset.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.scheduledjob.api.JobExecution));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, jobExecution);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.scheduledjob.api.LogEntry>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.api.ListResult<net.bluemind.scheduledjob.api.JobExecution> searchExecution(net.bluemind.scheduledjob.api.JobExecutionQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_searchExecution";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.scheduledjob.api.JobExecutionQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.api.ListResult<net.bluemind.scheduledjob.api.JobExecution>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.api.ListResult<net.bluemind.scheduledjob.api.Job> searchJob(net.bluemind.scheduledjob.api.JobQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_searchJob";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.scheduledjob.api.JobQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.api.ListResult<net.bluemind.scheduledjob.api.Job>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void start(String jobId, String domainName )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_start/{jobId}";
      methodPathValue = methodPathValue.Replace("{jobId}", HttpUtility.UrlEncode("" + jobId));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("domainName", domainName.ToString());

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(net.bluemind.scheduledjob.api.Job job )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_updateJob";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.scheduledjob.api.Job));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, job);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
